/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.treebank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cleartk.util.treebank.TopTreebankNode;
import org.cleartk.util.treebank.TreebankObject;

public class TreebankNode
implements TreebankObject {
    private TreebankNode parent = null;
    private List<TreebankNode> children = new ArrayList<TreebankNode>();
    private TopTreebankNode topNode = null;
    private int parseBegin;
    private int parseEnd;
    private int textBegin;
    private int textEnd;
    private String type;
    private String value;
    private String text;
    private String[] tags;
    private boolean leaf;

    public TopTreebankNode getTopNode() {
        return this.topNode;
    }

    public void setTopNode(TopTreebankNode top) {
        this.topNode = top;
    }

    public String getTreebankParse() {
        return this.getTopNode().getTreebankParse().substring(this.parseBegin, this.parseEnd);
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leafNode) {
        this.leaf = leafNode;
    }

    public List<TreebankNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void setChildren(List<TreebankNode> children) {
        this.children.clear();
        if (children != null) {
            this.children.addAll(children);
        }
    }

    public void addChild(TreebankNode child) {
        this.children.add(0, child);
    }

    public TreebankNode getParent() {
        return this.parent;
    }

    public TreebankNode getAncestor(int levels) {
        if (levels < 0) {
            return null;
        }
        TreebankNode returnNode = this;
        for (int i = 0; i < levels && (returnNode = returnNode.getParent()) != null; ++i) {
        }
        return returnNode;
    }

    public void setParent(TreebankNode parent) {
        this.parent = parent;
    }

    public int getParseBegin() {
        return this.parseBegin;
    }

    public int getParseEnd() {
        return this.parseEnd;
    }

    public void setParseBegin(int begin) {
        this.parseBegin = begin;
    }

    public void setParseEnd(int end) {
        this.parseEnd = end;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String displayText() {
        return this.displayText(0);
    }

    private String displayText(int tabs) {
        StringBuffer returnValue = new StringBuffer();
        String tabString = this.getTabs(tabs);
        returnValue.append(tabString + this.getType());
        if (this.getValue() != null) {
            returnValue.append(":" + this.getValue() + "\n");
        } else {
            returnValue.append(":" + this.getText() + "\n");
        }
        if (this.getChildren().size() > 0) {
            for (TreebankNode child : this.getChildren()) {
                returnValue.append(child.displayText(tabs + 1));
            }
        }
        return returnValue.toString();
    }

    private String getTabs(int tabs) {
        StringBuffer returnValue = new StringBuffer();
        for (int i = 0; i < tabs; ++i) {
            returnValue.append("  ");
        }
        return returnValue.toString();
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public int getTextBegin() {
        return this.textBegin;
    }

    public void setTextBegin(int textBegin) {
        this.textBegin = textBegin;
    }

    public int getTextEnd() {
        return this.textEnd;
    }

    public void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }
}

