/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.chunking.Parser;
import org.apache.ctakes.constituency.parser.ParserWrapper;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class MaxentParserWrapper
implements ParserWrapper {
    Parser parser = null;
    private String parseStr = "";
    Logger logger = Logger.getLogger((String)this.getClass().getName());

    public MaxentParserWrapper(InputStream is) {
        try {
            if (is != null) {
                ParserModel model = new ParserModel(is);
                this.parser = new Parser(model, 20, 0.95);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParseString(FSIterator tokens) {
        return this.parseStr;
    }

    @Override
    public void createAnnotations(JCas jcas) throws AnalysisEngineProcessException {
        String docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        this.logger.info((Object)("Started processing: " + docId));
        Parse parse = null;
        Collection allSentences = JCasUtil.select((JCas)jcas, Sentence.class);
        for (Sentence sentence : allSentences) {
            String text = sentence.getCoveredText();
            if (text.isEmpty() || MaxentParserWrapper.isBorderOnly(text)) continue;
            FSArray terminalArray = TreeUtils.getTerminals(jcas, sentence);
            String tokenString = TreeUtils.getSplitSentence(terminalArray);
            if (tokenString.isEmpty()) {
                parse = null;
            } else {
                Parse inputTokens = TreeUtils.ctakesTokensToOpennlpTokens(sentence.getBegin(), text, terminalArray);
                parse = this.parser.parse(inputTokens);
            }
            TopTreebankNode top = TreeUtils.buildAlignedTree(jcas, parse, terminalArray, sentence);
            top.addToIndexes();
        }
        this.logger.info((Object)("Done parsing: " + docId));
    }

    private static boolean isBorderOnly(String text) {
        char[] chars;
        for (char c : chars = text.toCharArray()) {
            if (!Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }
}

