/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.sparsematrix;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;
import org.apache.ctakes.ytex.libsvm.LibSVMFormatterFactory;
import org.apache.ctakes.ytex.sparsematrix.InstanceDataExporter;

public class SparseMatrixFormatterFactory
implements SparseDataFormatterFactory {
    InstanceDataExporter instanceDataExporter;
    KernelUtil kernelUtil;

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public InstanceDataExporter getInstanceDataExporter() {
        return this.instanceDataExporter;
    }

    public void setInstanceDataExporter(InstanceDataExporter instanceDataExporter) {
        this.instanceDataExporter = instanceDataExporter;
    }

    @Override
    public SparseDataFormatter getFormatter() {
        return new SparseMatrixDataFormatter(this.getInstanceDataExporter(), this.getKernelUtil());
    }

    public static class SparseMatrixDataFormatter
    extends LibSVMFormatterFactory.LibSVMFormatter {
        InstanceData instanceLabel;
        InstanceDataExporter instanceDataExporter;

        public SparseMatrixDataFormatter(InstanceDataExporter instanceDataExporter, KernelUtil kernelUtil) {
            super(kernelUtil);
            this.instanceDataExporter = instanceDataExporter;
        }

        @Override
        public void initializeExport(InstanceData instanceLabel, Properties properties, SparseData sparseData) throws IOException {
            super.initializeExport(instanceLabel, properties, sparseData);
            this.instanceLabel = instanceLabel;
            this.instanceDataExporter.outputInstanceData(instanceLabel, FileUtil.addFilenameToDir(this.outdir, "instance.txt"));
            if (properties.getProperty("scope") == null || properties.getProperty("scope").length() == 0) {
                this.exportSparseMatrix(sparseData, null, null, null);
            }
        }

        @Override
        public void initializeLabel(String label, SortedMap<Integer, SortedMap<Integer, SortedMap<Boolean, SortedMap<Long, String>>>> labelInstances, Properties properties, SparseData sparseData) throws IOException {
            if ("label".equals(this.exportProperties.getProperty("scope"))) {
                this.exportSparseMatrix(sparseData, label, null, null);
            }
        }

        @Override
        public void initializeFold(SparseData sparseData, String label, Integer run, Integer fold, SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap) throws IOException {
            if ("fold".equals(this.exportProperties.getProperty("scope"))) {
                this.exportSparseMatrix(sparseData, label, run, fold);
            }
        }

        @Override
        public void exportFold(SparseData sparseData, SortedMap<Long, String> instanceClassMap, boolean train, String label, Integer run, Integer fold) throws IOException {
        }

        private void exportSparseMatrix(SparseData sparseData, String label, Integer run, Integer fold) throws IOException {
            this.exportAttributeNames(sparseData, label, run, fold);
            String filename = FileUtil.getScopedFileName(this.outdir, label, run, fold, "data.txt");
            this.exportSparseMatrix(filename, sparseData);
        }

        @Override
        protected int exportAttributeNames(BufferedWriter w, SparseData sparseData) throws IOException {
            super.addNumericAttribute(w, "instance_id");
            return super.exportAttributeNames(w, sparseData);
        }

        @Override
        protected SortedMap<Integer, Double> getSparseLineValues(SparseData bagOfWordsData, Map<String, Integer> numericAttributeMap, Map<String, Map<String, Integer>> nominalAttributeMap, long instanceId) {
            SortedMap<Integer, Double> instanceLine = super.getSparseLineValues(bagOfWordsData, numericAttributeMap, nominalAttributeMap, instanceId);
            instanceLine.put((Integer)this.numericAttributeMap.get("instance_id"), Double.valueOf(instanceId));
            return instanceLine;
        }
    }
}

