/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.ctakes.ytex.kernel.evaluator.CacheKeyGenerator;
import org.apache.ctakes.ytex.kernel.evaluator.Kernel;
import org.apache.ctakes.ytex.kernel.evaluator.SymmetricPairCacheKeyGenerator;
import org.springframework.beans.factory.InitializingBean;

public abstract class CacheKernel
implements Kernel,
InitializingBean {
    private CacheManager cacheManager;
    private String cacheName;
    private Cache cache;
    private CacheKeyGenerator cacheKeyGenerator = new SymmetricPairCacheKeyGenerator();

    public CacheKeyGenerator getCacheKeyGenerator() {
        return this.cacheKeyGenerator;
    }

    public void setCacheKeyGenerator(CacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public abstract double innerEvaluate(Object var1, Object var2);

    @Override
    public double evaluate(Object o1, Object o2) {
        double dEval;
        if (this.cache == null) {
            dEval = this.innerEvaluate(o1, o2);
        } else {
            Object cacheKey = this.cacheKeyGenerator.getCacheKey(o1, o2);
            Element e = this.cache.get(cacheKey);
            if (e != null) {
                dEval = (Double)e.getValue();
            } else {
                dEval = this.innerEvaluate(o1, o2);
                this.cache.put(new Element(cacheKey, (Object)dEval));
            }
        }
        return dEval;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cacheName != null) {
            this.cache = this.cacheManager.getCache(this.cacheName);
        }
    }
}

