/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ConversionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled(value="Ignored pre JUnit v5")
    public void testFileNameWithCharacters() throws URISyntaxException, IOException {
        File file = new File("target", "+# %&.txt");
        String fileURL = file.toURI().toURL().toExternalForm();
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(file.toURI().getPath()));
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fileURL).toURI().getPath()));
        try {
            Files.newOutputStream(file.toPath(), new OpenOption[0]).close();
            Assertions.assertTrue((boolean)file.exists());
            FileSystemManager manager = VFS.getManager();
            FileObject fo = manager.resolveFile(fileURL);
            Assertions.assertTrue((boolean)fo.exists());
            Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fo.getURL().toExternalForm()).toURI().getPath()));
        }
        finally {
            file.delete();
        }
    }

    @Test
    @Disabled(value="Ignored pre JUnit v5")
    public void testFileNameWithSpaces() throws URISyntaxException, IOException {
        File file = new File("target", "a name.txt");
        String fileURL = file.toURI().toURL().toExternalForm();
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(file.toURI().getPath()));
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fileURL).toURI().getPath()));
        FileSystemManager manager = VFS.getManager();
        FileObject fo = manager.resolveFile(fileURL);
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fo.getURL().toExternalForm()).toURI().getPath()));
    }
}

