/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.stream.Stream;
import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractL128;
import org.apache.commons.rng.core.source64.LXMSupport;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.core.util.RandomStreams;

public class L128X256Mix
extends AbstractL128
implements SplittableUniformRandomProvider {
    private static final int SEED_SIZE = 8;
    private static final int XBG_STATE_SIZE = 4;
    private static final long ML = -3024805186288043011L;
    private long x0;
    private long x1;
    private long x2;
    private long x3;

    public L128X256Mix(long[] seed) {
        seed = L128X256Mix.extendSeed(seed, 8);
        super(seed);
        this.x0 = seed[4];
        this.x1 = seed[5];
        this.x2 = seed[6];
        this.x3 = seed[7];
    }

    public L128X256Mix(long seed0, long seed1, long seed2, long seed3, long seed4, long seed5, long seed6, long seed7) {
        super(seed0, seed1, seed2, seed3);
        this.x0 = seed4;
        this.x1 = seed5;
        this.x2 = seed6;
        this.x3 = seed7;
    }

    protected L128X256Mix(L128X256Mix source) {
        super(source);
        this.x0 = source.x0;
        this.x1 = source.x1;
        this.x2 = source.x2;
        this.x3 = source.x3;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.x0, this.x1, this.x2, this.x3}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 32);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        this.x0 = tmp[0];
        this.x1 = tmp[1];
        this.x2 = tmp[2];
        this.x3 = tmp[3];
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        long s0 = this.x0;
        long sh = this.lsh;
        long z = LXMSupport.lea64(sh + s0);
        long sl = this.lsl;
        long al = this.lal;
        long u = -3024805186288043011L * sl;
        this.lsh = -3024805186288043011L * sh + LXMSupport.unsignedMultiplyHigh(-3024805186288043011L, sl) + sl + this.lah + LXMSupport.unsignedAddHigh(u, al);
        this.lsl = u + al;
        long s1 = this.x1;
        long s2 = this.x2;
        long s3 = this.x3;
        long t = s1 << 17;
        s3 ^= s1;
        s1 ^= (s2 ^= s0);
        s0 ^= s3;
        s3 = Long.rotateLeft(s3, 45);
        this.x0 = s0;
        this.x1 = s1;
        this.x2 = s2 ^= t;
        this.x3 = s3;
        return z;
    }

    @Override
    public UniformRandomProvider jump() {
        return super.jump();
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        return super.longJump();
    }

    @Override
    AbstractL128 copy() {
        return new L128X256Mix(this);
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider source) {
        return L128X256Mix.create(source.nextLong(), source);
    }

    public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        return RandomStreams.generateWithSeed(streamSize, source, L128X256Mix::create);
    }

    private static SplittableUniformRandomProvider create(long seed, UniformRandomProvider source) {
        long x3;
        long x2;
        long x1;
        long s0 = source.nextLong();
        long s1 = seed << 1;
        long s2 = source.nextLong();
        long s3 = source.nextLong();
        long x0 = source.nextLong();
        if ((x0 | (x1 = source.nextLong()) | (x2 = source.nextLong()) | (x3 = source.nextLong())) == 0L) {
            long z = s3;
            x0 = LXMSupport.lea64(z);
            x1 = LXMSupport.lea64(z += -7046029254386353131L);
            x2 = LXMSupport.lea64(z += -7046029254386353131L);
            x3 = LXMSupport.lea64(z + -7046029254386353131L);
        }
        return new L128X256Mix(s0, s1, s2, s3, x0, x1, x2, x3);
    }
}

