/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;

final class TestSynchronizedPooledObjectFactory<T>
implements PooledObjectFactory<T> {
    private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
    private final PooledObjectFactory<T> factory;

    TestSynchronizedPooledObjectFactory(PooledObjectFactory<T> factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null.");
        }
        this.factory = factory;
    }

    public void activateObject(PooledObject<T> p) throws Exception {
        this.writeLock.lock();
        try {
            this.factory.activateObject(p);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void destroyObject(PooledObject<T> p) throws Exception {
        this.writeLock.lock();
        try {
            this.factory.destroyObject(p);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public PooledObject<T> makeObject() throws Exception {
        this.writeLock.lock();
        try {
            PooledObject pooledObject = this.factory.makeObject();
            return pooledObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void passivateObject(PooledObject<T> p) throws Exception {
        this.writeLock.lock();
        try {
            this.factory.passivateObject(p);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SynchronizedPoolableObjectFactory");
        sb.append("{factory=").append(this.factory);
        sb.append('}');
        return sb.toString();
    }

    public boolean validateObject(PooledObject<T> p) {
        this.writeLock.lock();
        try {
            boolean bl = this.factory.validateObject(p);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

