/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.hsql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheFactory;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class HSQLDiskCacheFactory
extends JDBCDiskCacheFactory {
    private static final Log log = LogManager.getLog(HSQLDiskCacheFactory.class);

    @Override
    public <K, V> JDBCDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        System.setProperty("hsqldb.cache_scale", "8");
        AuxiliaryCache cache = super.createCache(rawAttr, compositeCacheManager, cacheEventLogger, elementSerializer);
        this.setupDatabase(((JDBCDiskCache)cache).getDataSource(), (JDBCDiskCacheAttributes)rawAttr);
        return cache;
    }

    protected void setupDatabase(DataSource ds, JDBCDiskCacheAttributes attributes) throws SQLException {
        try (Connection cConn = ds.getConnection();){
            this.setupTable(cConn, attributes.getTableName());
            log.info("Finished setting up table [{0}]", attributes.getTableName());
        }
    }

    protected synchronized void setupTable(Connection cConn, String tableName) throws SQLException {
        DatabaseMetaData dmd = cConn.getMetaData();
        ResultSet result = dmd.getTables(null, null, tableName, null);
        if (!result.next()) {
            StringBuilder createSql = new StringBuilder();
            createSql.append("CREATE CACHED TABLE ").append(tableName);
            createSql.append("( ");
            createSql.append("CACHE_KEY             VARCHAR(250)          NOT NULL, ");
            createSql.append("REGION                VARCHAR(250)          NOT NULL, ");
            createSql.append("ELEMENT               BINARY, ");
            createSql.append("CREATE_TIME           TIMESTAMP, ");
            createSql.append("UPDATE_TIME_SECONDS   BIGINT, ");
            createSql.append("MAX_LIFE_SECONDS      BIGINT, ");
            createSql.append("SYSTEM_EXPIRE_TIME_SECONDS      BIGINT, ");
            createSql.append("IS_ETERNAL            CHAR(1), ");
            createSql.append("PRIMARY KEY (CACHE_KEY, REGION) ");
            createSql.append(");");
            try (Statement sStatement = cConn.createStatement();){
                sStatement.execute(createSql.toString());
            }
        }
    }
}

