/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleFunction;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.Mesh;
import org.apache.commons.geometry.io.core.utils.AbstractTextFormatWriter;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;

public final class ObjWriter
extends AbstractTextFormatWriter {
    private static final char SPACE = ' ';
    private int vertexCount;
    private int normalCount;

    public ObjWriter(Writer writer) {
        super(writer);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int getVertexNormalCount() {
        return this.normalCount;
    }

    public void writeComment(String comment) {
        for (String line : comment.split("\\R")) {
            this.write('#');
            this.write(' ');
            this.write(line);
            this.writeNewLine();
        }
    }

    public void writeObjectName(String objectName) {
        this.writeKeywordLine("o", objectName);
    }

    public void writeGroupName(String groupName) {
        this.writeKeywordLine("g", groupName);
    }

    public int writeVertex(Vector3D vertex) {
        return this.writeVertexLine(this.createVectorString(vertex));
    }

    public int writeVertexNormal(Vector3D normal) {
        return this.writeVertexNormalLine(this.createVectorString(normal));
    }

    public void writeFace(int ... vertexIndices) {
        this.writeFaceWithOffsets(0, vertexIndices, 0, null);
    }

    public void writeFace(int[] vertexIndices, int normalIndex) {
        int[] normalIndices = new int[vertexIndices.length];
        Arrays.fill(normalIndices, normalIndex);
        this.writeFaceWithOffsets(0, vertexIndices, 0, normalIndices);
    }

    public void writeFace(int[] vertexIndices, int[] normalIndices) {
        this.writeFaceWithOffsets(0, vertexIndices, 0, normalIndices);
    }

    public void writeBoundaries(BoundarySource3D src) {
        this.writeBoundaries(src, -1);
    }

    public void writeBoundaries(BoundarySource3D src, int batchSize) {
        MeshBuffer buffer = this.meshBuffer(batchSize);
        try (Stream stream = src.boundaryStream();){
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                buffer.add((PlaneConvexSubset)it.next());
            }
        }
        buffer.flush();
    }

    public void writeMesh(Mesh<?> mesh) {
        int vertexOffset = this.vertexCount;
        for (Vector3D vertex : mesh.vertices()) {
            this.writeVertex(vertex);
        }
        for (Mesh.Face face : mesh.faces()) {
            this.writeFaceWithOffsets(vertexOffset, face.getVertexIndices(), 0, null);
        }
    }

    public MeshBuffer meshBuffer() {
        return this.meshBuffer(-1);
    }

    public MeshBuffer meshBuffer(int batchSize) {
        return new MeshBuffer(batchSize);
    }

    private void writeFaceWithOffsets(int vertexOffset, int[] vertexIndices, int normalOffset, int[] normalIndices) {
        if (vertexIndices.length < 3) {
            throw new IllegalArgumentException("Face must have more than 3 vertices; found " + vertexIndices.length);
        }
        if (normalIndices != null && normalIndices.length != vertexIndices.length) {
            throw new IllegalArgumentException("Face normal index count must equal vertex index count; expected " + vertexIndices.length + " but was " + normalIndices.length);
        }
        this.write("f");
        for (int i = 0; i < vertexIndices.length; ++i) {
            int vertexIdx = vertexIndices[i] + vertexOffset;
            if (vertexIdx < 0 || vertexIdx >= this.vertexCount) {
                throw new IndexOutOfBoundsException("Vertex index out of bounds: " + vertexIdx);
            }
            this.write(' ');
            this.write(vertexIdx + 1);
            if (normalIndices == null) continue;
            int normalIdx = normalIndices[i] + normalOffset;
            if (normalIdx < 0 || normalIdx >= this.normalCount) {
                throw new IndexOutOfBoundsException("Normal index out of bounds: " + normalIdx);
            }
            this.write('/');
            this.write('/');
            this.write(normalIdx + 1);
        }
        this.writeNewLine();
    }

    private String createVectorString(Vector3D vec) {
        DoubleFunction fmt = this.getDoubleFormat();
        StringBuilder sb = new StringBuilder();
        sb.append((String)fmt.apply(vec.getX())).append(' ').append((String)fmt.apply(vec.getY())).append(' ').append((String)fmt.apply(vec.getZ()));
        return sb.toString();
    }

    private int writeVertexLine(String content) {
        this.writeKeywordLine("v", content);
        return this.vertexCount++;
    }

    private int writeVertexNormalLine(String content) {
        this.writeKeywordLine("vn", content);
        return this.normalCount++;
    }

    private void writeKeywordLine(String keyword, String content) {
        this.write(keyword);
        this.write(' ');
        this.write(content);
        this.writeNewLine();
    }

    public final class MeshBuffer {
        private final int batchSize;
        private final Map<String, Integer> vertexMap = new LinkedHashMap<String, Integer>();
        private final Map<String, Integer> normalMap = new LinkedHashMap<String, Integer>();
        private final List<int[]> faceVertices;
        private final Map<Integer, Integer> faceToNormalMap = new HashMap<Integer, Integer>();

        MeshBuffer(int batchSize) {
            this.batchSize = batchSize;
            this.faceVertices = batchSize > -1 ? new ArrayList<int[]>(batchSize) : new ArrayList();
        }

        public void add(FacetDefinition facet) {
            this.addFace(facet.getVertices(), facet.getNormal());
        }

        public void add(PlaneConvexSubset boundary) {
            if (boundary.isInfinite()) {
                throw new IllegalArgumentException("OBJ input geometry cannot be infinite: " + boundary);
            }
            if (!boundary.isEmpty()) {
                this.addFace(boundary.getVertices(), null);
            }
        }

        public int addVertex(Vector3D vertex) {
            return this.addToMap(vertex, this.vertexMap);
        }

        public int addNormal(Vector3D normal) {
            return this.addToMap(normal, this.normalMap);
        }

        public void flush() {
            int vertexOffset = ObjWriter.this.vertexCount;
            int normalOffset = ObjWriter.this.normalCount;
            for (String vertexStr : this.vertexMap.keySet()) {
                ObjWriter.this.writeVertexLine(vertexStr);
            }
            for (String normalStr : this.normalMap.keySet()) {
                ObjWriter.this.writeVertexNormalLine(normalStr);
            }
            int faceIndex = 0;
            for (int[] vertexIndices : this.faceVertices) {
                int[] normalIndices;
                Integer normalIndex = this.faceToNormalMap.get(faceIndex);
                if (normalIndex != null) {
                    normalIndices = new int[vertexIndices.length];
                    Arrays.fill(normalIndices, normalIndex);
                } else {
                    normalIndices = null;
                }
                ObjWriter.this.writeFaceWithOffsets(vertexOffset, vertexIndices, normalOffset, normalIndices);
                ++faceIndex;
            }
            this.reset();
        }

        private int addToMap(Vector3D vec, Map<String, Integer> map) {
            String str = ObjWriter.this.createVectorString(vec);
            return map.computeIfAbsent(str, k -> map.size());
        }

        private void addFace(List<Vector3D> vertices, Vector3D normal) {
            int faceIndex = this.faceVertices.size();
            int[] vertexIndices = new int[vertices.size()];
            int i = -1;
            for (Vector3D vertex : vertices) {
                vertexIndices[++i] = this.addVertex(vertex);
            }
            this.faceVertices.add(vertexIndices);
            if (normal != null) {
                this.faceToNormalMap.put(faceIndex, this.addNormal(normal));
            }
            if (this.batchSize > -1 && this.faceVertices.size() >= this.batchSize) {
                this.flush();
            }
        }

        private void reset() {
            this.vertexMap.clear();
            this.normalMap.clear();
            this.faceVertices.clear();
            this.faceToNormalMap.clear();
        }
    }
}

