/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.geometry.euclidean.threed.BoundaryList3D;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.ConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.mesh.SimpleTriangleMesh;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.BoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitions;
import org.apache.commons.numbers.core.Precision;

public abstract class AbstractBoundaryReadHandler3D
implements BoundaryReadHandler3D {
    public BoundarySource3D read(GeometryInput in, Precision.DoubleEquivalence precision) {
        ArrayList<ConvexPolygon3D> list = new ArrayList<ConvexPolygon3D>();
        try (FacetDefinitionReader reader = this.facetDefinitionReader(in);){
            FacetDefinition facet;
            while ((facet = reader.readFacet()) != null) {
                list.add(FacetDefinitions.toPolygon(facet, precision));
            }
        }
        return new BoundaryList3D(list);
    }

    @Override
    public TriangleMesh readTriangleMesh(GeometryInput in, Precision.DoubleEquivalence precision) {
        SimpleTriangleMesh.Builder meshBuilder = SimpleTriangleMesh.builder((Precision.DoubleEquivalence)precision);
        try (FacetDefinitionReader reader = this.facetDefinitionReader(in);){
            FacetDefinition facet;
            while ((facet = reader.readFacet()) != null) {
                for (Triangle3D tri : FacetDefinitions.toPolygon(facet, precision).toTriangles()) {
                    meshBuilder.addFaceUsingVertices(tri.getPoint1(), tri.getPoint2(), tri.getPoint3());
                }
            }
        }
        return meshBuilder.build();
    }

    public Stream<PlaneConvexSubset> boundaries(GeometryInput in, Precision.DoubleEquivalence precision) {
        return this.facets(in).map(f -> FacetDefinitions.toPolygon(f, precision));
    }

    @Override
    public Stream<FacetDefinition> facets(GeometryInput in) {
        return GeometryIOUtils.createCloseableStream(inputStream -> {
            FacetDefinitionReader fdReader = this.facetDefinitionReader(in);
            FacetDefinitionReaderIterator it = new FacetDefinitionReaderIterator(fdReader);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
        }, () -> ((GeometryInput)in).getInputStream());
    }

    static final class FacetDefinitionReaderIterator
    implements Iterator<FacetDefinition> {
        private final FacetDefinitionReader reader;
        private int loadCount = 0;
        private FacetDefinition next;

        FacetDefinitionReaderIterator(FacetDefinitionReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            this.ensureLoaded();
            return this.next != null;
        }

        @Override
        public FacetDefinition next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FacetDefinition result = this.next;
            this.loadNext();
            return result;
        }

        private void ensureLoaded() {
            if (this.loadCount < 1) {
                this.loadNext();
            }
        }

        private void loadNext() {
            ++this.loadCount;
            this.next = this.reader.readFacet();
        }
    }
}

