/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod.path;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.geometry.euclidean.internal.AbstractPathConnector;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;
import org.apache.commons.numbers.angle.Angle;

public abstract class AbstractLinePathConnector
extends AbstractPathConnector<ConnectableLineSubset> {
    public void add(LineConvexSubset subset) {
        this.addPathElement(new ConnectableLineSubset(subset));
    }

    public void add(Iterable<? extends LineConvexSubset> subsets) {
        for (LineConvexSubset lineConvexSubset : subsets) {
            this.add(lineConvexSubset);
        }
    }

    public void connect(Iterable<? extends LineConvexSubset> subsets) {
        ArrayList<ConnectableLineSubset> newEntries = new ArrayList<ConnectableLineSubset>();
        for (LineConvexSubset lineConvexSubset : subsets) {
            newEntries.add(new ConnectableLineSubset(lineConvexSubset));
        }
        this.connectPathElements(newEntries);
    }

    public List<LinePath> connectAll(Iterable<LineConvexSubset> subsets) {
        this.add(subsets);
        return this.connectAll();
    }

    public List<LinePath> connectAll() {
        List roots = this.computePathRoots();
        ArrayList<LinePath> paths = new ArrayList<LinePath>(roots.size());
        for (ConnectableLineSubset root : roots) {
            paths.add(this.toPath(root));
        }
        return paths;
    }

    private LinePath toPath(ConnectableLineSubset root) {
        LinePath.Builder builder = LinePath.builder(null);
        builder.append(root.getLineSubset());
        for (ConnectableLineSubset current = (ConnectableLineSubset)root.getNext(); current != null && current != root; current = (ConnectableLineSubset)current.getNext()) {
            builder.append(current.getLineSubset());
        }
        return builder.build();
    }

    protected static class ConnectableLineSubset
    extends AbstractPathConnector.ConnectableElement<ConnectableLineSubset> {
        private final Vector2D start;
        private final LineConvexSubset subset;

        public ConnectableLineSubset(Vector2D start) {
            this(start, null);
        }

        public ConnectableLineSubset(LineConvexSubset subset) {
            this(subset.getStartPoint(), subset);
        }

        private ConnectableLineSubset(Vector2D start, LineConvexSubset subset) {
            this.start = start;
            this.subset = subset;
        }

        public LineConvexSubset getLineSubset() {
            return this.subset;
        }

        @Override
        public boolean hasStart() {
            return this.start != null;
        }

        @Override
        public boolean hasEnd() {
            return this.subset != null && this.subset.getEndPoint() != null;
        }

        public boolean hasZeroSize() {
            return this.subset != null && this.subset.getPrecision().eqZero(this.subset.getSize());
        }

        @Override
        public boolean endPointsEq(ConnectableLineSubset other) {
            if (this.hasEnd() && other.hasEnd()) {
                return this.subset.getEndPoint().eq(other.subset.getEndPoint(), this.subset.getPrecision());
            }
            return false;
        }

        @Override
        public boolean canConnectTo(ConnectableLineSubset next) {
            Vector2D end = this.subset.getEndPoint();
            Vector2D nextStart = next.start;
            return end != null && nextStart != null && end.eq(nextStart, this.subset.getPrecision());
        }

        @Override
        public double getRelativeAngle(ConnectableLineSubset next) {
            return this.subset.getLine().angle(next.getLineSubset().getLine());
        }

        @Override
        public ConnectableLineSubset getConnectionSearchKey() {
            return new ConnectableLineSubset(this.subset.getEndPoint());
        }

        @Override
        public boolean shouldContinueConnectionSearch(ConnectableLineSubset candidate, boolean ascending) {
            if (candidate.hasStart()) {
                double candidateX = candidate.getLineSubset().getStartPoint().getX();
                double thisX = this.subset.getEndPoint().getX();
                int cmp = this.subset.getPrecision().compare(candidateX, thisX);
                return ascending ? cmp <= 0 : cmp >= 0;
            }
            return true;
        }

        @Override
        public int compareTo(ConnectableLineSubset other) {
            int cmp = Vector2D.COORDINATE_ASCENDING_ORDER.compare(this.start, other.start);
            if (cmp == 0) {
                boolean thisHasSubset = this.subset != null;
                boolean otherHasSubset = other.subset != null;
                cmp = Boolean.compare(thisHasSubset, otherHasSubset);
                if (cmp == 0 && thisHasSubset && (cmp = Boolean.compare(this.hasZeroSize(), other.hasZeroSize())) == 0) {
                    double aAngle = Angle.Rad.WITHIN_MINUS_PI_AND_PI.applyAsDouble(this.getLineSubset().getLine().getAngle());
                    double bAngle = Angle.Rad.WITHIN_MINUS_PI_AND_PI.applyAsDouble(other.getLineSubset().getLine().getAngle());
                    cmp = Double.compare(aAngle, bAngle);
                }
            }
            return cmp;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.subset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            ConnectableLineSubset other = (ConnectableLineSubset)obj;
            return Objects.equals(this.start, other.start) && Objects.equals(this.subset, other.subset);
        }

        @Override
        protected ConnectableLineSubset getSelf() {
            return this;
        }
    }
}

