/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.AbstractConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;

final class VertexListConvexPolygon3D
extends AbstractConvexPolygon3D {
    private final List<Vector3D> vertices;

    VertexListConvexPolygon3D(Plane plane, List<Vector3D> vertices) {
        super(plane);
        if (vertices.size() < 3) {
            throw new IllegalArgumentException("Convex polygon requires at least 3 points; found " + vertices.size());
        }
        this.vertices = Collections.unmodifiableList(vertices);
    }

    @Override
    public List<Vector3D> getVertices() {
        return this.vertices;
    }

    @Override
    public List<Triangle3D> toTriangles() {
        return Planes.convexPolygonToTriangleFan(this.getPlane(), this.vertices);
    }

    @Override
    public VertexListConvexPolygon3D transform(Transform<Vector3D> transform) {
        Plane tPlane = this.getPlane().transform(transform);
        List<Vector3D> tVertices = this.vertices.stream().map(transform).collect(Collectors.toList());
        return new VertexListConvexPolygon3D(tPlane, tVertices);
    }

    @Override
    public VertexListConvexPolygon3D reverse() {
        Plane rPlane = this.getPlane().reverse();
        ArrayList<Vector3D> rVertices = new ArrayList<Vector3D>(this.vertices);
        Collections.reverse(rVertices);
        return new VertexListConvexPolygon3D(rPlane, rVertices);
    }
}

