/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.ConnectionPoolDataSourceProxy;
import org.apache.commons.dbcp2.datasources.KeyedCPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestKeyedCPDSConnectionFactory {
    protected ConnectionPoolDataSourceProxy cpds;

    @BeforeEach
    public void setUp() throws Exception {
        this.cpds = new ConnectionPoolDataSourceProxy((ConnectionPoolDataSource)new DriverAdapterCPDS());
        DriverAdapterCPDS delegate = (DriverAdapterCPDS)this.cpds.getDelegate();
        delegate.setDriver("org.apache.commons.dbcp2.TesterDriver");
        delegate.setUrl("jdbc:apache:commons:testdriver");
        delegate.setUser("userName");
        delegate.setPassword("password");
    }

    @Test
    void testConnectionErrorCleanup() throws Exception {
        UserPassKey key = new UserPassKey("userName", "password");
        KeyedCPDSConnectionFactory factory = new KeyedCPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, Duration.ofSeconds(-1L), false);
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory);){
            factory.setPool((KeyedObjectPool)pool);
            PooledConnection pcon1 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
            try (Connection con1 = pcon1.getConnection();){
                PooledConnection pcon2 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
                Assertions.assertEquals((int)2, (int)pool.getNumActive((Object)key));
                Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
                PooledConnectionProxy pc = (PooledConnectionProxy)pcon1;
                Assertions.assertTrue((boolean)pc.getListeners().contains(factory));
                pc.throwConnectionError();
                Assertions.assertEquals((int)1, (int)pool.getNumActive((Object)key));
                Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
                pc.throwConnectionError();
                Assertions.assertEquals((int)1, (int)pool.getNumActive((Object)key));
                Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
                PooledConnection pcon3 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
                Assertions.assertNotEquals((Object)pcon3, (Object)pcon1);
                Assertions.assertFalse((boolean)pc.getListeners().contains(factory));
                Assertions.assertEquals((int)2, (int)pool.getNumActive((Object)key));
                Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
                pcon2.getConnection().close();
                pcon3.getConnection().close();
                Assertions.assertEquals((int)2, (int)pool.getNumIdle((Object)key));
                Assertions.assertEquals((int)0, (int)pool.getNumActive((Object)key));
                Assertions.assertThrows(SQLException.class, pc::getConnection, (String)"Expecting SQLException using closed PooledConnection");
            }
            Assertions.assertEquals((int)2, (int)pool.getNumIdle((Object)key));
            Assertions.assertEquals((int)0, (int)pool.getNumActive((Object)key));
            pool.clear();
            Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
        }
    }

    @Test
    void testNullValidationQuery() throws Exception {
        UserPassKey key = new UserPassKey("userName", "password");
        KeyedCPDSConnectionFactory factory = new KeyedCPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, Duration.ofSeconds(-1L), false);
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory);){
            factory.setPool((KeyedObjectPool)pool);
            pool.setTestOnBorrow(true);
            PooledConnection pcon = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
            Connection con = pcon.getConnection();
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    void testSharedPoolDSDestroyOnReturn() throws Exception {
        try (SharedPoolDataSource ds = new SharedPoolDataSource();){
            ds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.cpds);
            ds.setMaxTotal(10);
            ds.setDefaultMaxWait(Duration.ofMillis(50L));
            ds.setDefaultMaxIdle(2);
            Connection conn1 = ds.getConnection("userName", "password");
            Connection conn2 = ds.getConnection("userName", "password");
            Connection conn3 = ds.getConnection("userName", "password");
            Assertions.assertEquals((int)3, (int)ds.getNumActive());
            conn1.close();
            Assertions.assertEquals((int)1, (int)ds.getNumIdle());
            conn2.close();
            Assertions.assertEquals((int)2, (int)ds.getNumIdle());
            conn3.close();
            Assertions.assertEquals((int)2, (int)ds.getNumIdle());
        }
    }
}

