/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjAttributeValidator
extends ConfigurationNodeValidator<ObjAttribute> {
    public ObjAttributeValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(ObjAttribute node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.OBJ_ATTRIBUTE_NO_NAME, this::checkForName).performIfEnabled(Inspection.OBJ_ATTRIBUTE_INVALID_NAME, this::validateName).performIfEnabled(Inspection.OBJ_ATTRIBUTE_NO_TYPE, this::checkForType).performIfEnabled(Inspection.OBJ_ATTRIBUTE_NO_EMBEDDABLE, this::checkForEmbeddable).performIfEnabled(Inspection.OBJ_ATTRIBUTE_INVALID_MAPPING, this::validateDbAttributeMapping).performIfEnabled(Inspection.OBJ_ATTRIBUTE_PATH_DUPLICATE, this::checkForPathDuplicates).performIfEnabled(Inspection.OBJ_ATTRIBUTE_SUPER_NAME_DUPLICATE, this::checkOnNameDuplicatesInSuperEntity);
    }

    private void checkForName(ObjAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString((CharSequence)attribute.getName())) {
            this.addFailure(validationResult, attribute, "Unnamed ObjAttribute", new Object[0]);
        }
    }

    private void validateName(ObjAttribute attribute, ValidationResult validationResult) {
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInObjPathComponent(attribute.getName());
        if (invalidChars != null) {
            this.addFailure(validationResult, attribute, "ObjAttribute name '%s' contains invalid characters: %s", attribute.getName(), invalidChars);
        } else if (helper.invalidPersistentObjectProperty(attribute.getName())) {
            this.addFailure(validationResult, attribute, "ObjAttribute name '%s' is invalid", attribute.getName());
        }
    }

    private void checkForType(ObjAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString((CharSequence)attribute.getType())) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has no Java type", attribute.getName());
        }
    }

    private void checkForEmbeddable(ObjAttribute attribute, ValidationResult validationResult) {
        if (!(attribute instanceof EmbeddedAttribute)) {
            return;
        }
        Embeddable embeddable = ((EmbeddedAttribute)attribute).getEmbeddable();
        if (embeddable == null) {
            String msg = attribute.getType() == null ? "EmbeddedAttribute '%s' has no Embeddable" : "EmbeddedAttribute '%s' has incorrect Embeddable";
            this.addFailure(validationResult, attribute, msg, attribute.getName());
        }
    }

    private void validateDbAttributeMapping(ObjAttribute attribute, ValidationResult validationResult) {
        if (attribute instanceof EmbeddedAttribute) {
            this.validateDbAttributeMappingEmbedded((EmbeddedAttribute)attribute, validationResult);
        } else {
            this.validateDbAttributeMappingGeneral(attribute, validationResult);
        }
    }

    private void validateDbAttributeMappingEmbedded(EmbeddedAttribute attribute, ValidationResult validationResult) {
        Embeddable embeddable = attribute.getEmbeddable();
        if (embeddable == null) {
            return;
        }
        Map attrOverrides = attribute.getAttributeOverrides();
        for (EmbeddableAttribute embeddableAttribute : embeddable.getAttributes()) {
            String dbAttributeName;
            String string = dbAttributeName = attrOverrides.containsKey(embeddableAttribute.getName()) ? (String)attrOverrides.get(embeddableAttribute.getName()) : embeddableAttribute.getDbAttributeName();
            if (Util.isEmptyString((CharSequence)dbAttributeName)) {
                this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has no DbAttribute mapping", attribute.getName());
                continue;
            }
            if (attribute.getEntity().getDbEntity().getAttribute(dbAttributeName) != null) continue;
            this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has invalid DbAttribute mapping", attribute.getName());
        }
    }

    private void validateDbAttributeMappingGeneral(ObjAttribute attribute, ValidationResult validationResult) {
        DbAttribute dbAttribute;
        if (attribute.getEntity().isAbstract()) {
            return;
        }
        try {
            dbAttribute = attribute.getDbAttribute();
        }
        catch (ExpressionException e) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has invalid DB path: %s", attribute.getName(), e.getExpressionString());
            return;
        }
        if (dbAttribute == null) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has no DbAttribute mapping", attribute.getName());
            return;
        }
        if (dbAttribute.isPrimaryKey() && dbAttribute.isGenerated()) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' is mapped to a generated PK: %s", attribute.getName(), attribute.getDbAttributeName());
        }
    }

    private void checkForPathDuplicates(ObjAttribute attribute, ValidationResult validationResult) {
        if (attribute == null || attribute.getName() == null || attribute.isInherited()) {
            return;
        }
        ObjEntity entity = attribute.getEntity();
        CayennePath dbAttributePath = attribute.getDbAttributePath();
        for (ObjAttribute comparisonAttribute : entity.getAttributes()) {
            if (attribute == comparisonAttribute || dbAttributePath == null || !dbAttributePath.equals(comparisonAttribute.getDbAttributePath())) continue;
            this.addFailure(validationResult, attribute, "ObjEntity '%s' contains a duplicate DbAttribute mapping ('%s' -> '%s')", entity.getName(), attribute.getName(), dbAttributePath);
            return;
        }
    }

    private void checkOnNameDuplicatesInSuperEntity(ObjAttribute attribute, ValidationResult validationResult) {
        boolean selfAttribute = attribute.getEntity().getDeclaredAttribute(attribute.getName()) != null;
        ObjEntity superEntity = attribute.getEntity().getSuperEntity();
        if (selfAttribute && superEntity != null && superEntity.getAttribute(attribute.getName()) != null) {
            this.addFailure(validationResult, attribute, "'%s' and super '%s' can't both have attribute '%s'", attribute.getEntity().getName(), superEntity.getName(), attribute.getName());
        }
    }
}

