/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.sql.DataSource;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ValidationResultBrowser;
import org.apache.cayenne.modeler.dialog.db.DBGeneratorOptionsView;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.TableSelectorController;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DBGeneratorDefaults;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.DbAdapterInfo;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.validation.ValidationResult;

public class DBGeneratorOptions
extends CayenneController {
    protected DBGeneratorOptionsView view;
    protected ObjectBinding[] optionBindings;
    protected ObjectBinding sqlBinding;
    protected ObjectBinding adapterBinding;
    protected DBConnectionInfo connectionInfo;
    protected DataMap dataMap;
    protected DBGeneratorDefaults generatorDefaults;
    protected DbGenerator generator;
    protected String textForSQL;
    protected TableSelectorController tables;

    public DBGeneratorOptions(ProjectController parent, String title, DataMap dataMap) {
        super(parent);
        this.dataMap = dataMap;
        this.tables = new TableSelectorController(parent);
        this.view = new DBGeneratorOptionsView(this.tables.getView());
        this.connectionInfo = new DBConnectionInfo();
        this.generatorDefaults = new DBGeneratorDefaults(parent.getPreferenceForProject().node("DbGenerator"));
        this.view.setTitle(title);
        this.initController();
        this.connectionInfo.setDbAdapter((String)this.view.getAdapters().getSelectedItem());
        this.tables.updateTables(dataMap);
        this.prepareGenerator();
        this.generatorDefaults.configureGenerator(this.generator);
        this.createSQL();
        this.refreshView();
    }

    public Component getView() {
        return this.view;
    }

    public DBGeneratorDefaults getGeneratorDefaults() {
        return this.generatorDefaults;
    }

    public String getTextForSQL() {
        return this.textForSQL;
    }

    protected void initController() {
        DefaultComboBoxModel<Object> adapterModel = new DefaultComboBoxModel<Object>(DbAdapterInfo.getStandardAdapters());
        this.view.getAdapters().setModel(adapterModel);
        this.view.getAdapters().setSelectedIndex(0);
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.sqlBinding = builder.bindToTextArea(this.view.getSql(), "textForSQL");
        this.adapterBinding = builder.bindToComboSelection(this.view.getAdapters(), "connectionInfo.dbAdapter", "refreshSQLAction()", "org.apache.cayenne.dba.JdbcAdapter");
        this.optionBindings = new ObjectBinding[5];
        this.optionBindings[0] = builder.bindToStateChangeAndAction(this.view.getCreateFK(), "generatorDefaults.createFK", "refreshSQLAction()");
        this.optionBindings[1] = builder.bindToStateChangeAndAction(this.view.getCreatePK(), "generatorDefaults.createPK", "refreshSQLAction()");
        this.optionBindings[2] = builder.bindToStateChangeAndAction(this.view.getCreateTables(), "generatorDefaults.createTables", "refreshSQLAction()");
        this.optionBindings[3] = builder.bindToStateChangeAndAction(this.view.getDropPK(), "generatorDefaults.dropPK", "refreshSQLAction()");
        this.optionBindings[4] = builder.bindToStateChangeAndAction(this.view.getDropTables(), "generatorDefaults.dropTables", "refreshSQLAction()");
        builder.bindToAction(this.view.getGenerateButton(), "generateSchemaAction()");
        builder.bindToAction(this.view.getSaveSqlButton(), "storeSQLAction()");
        builder.bindToAction(this.view.getCancelButton(), "closeAction()");
        this.view.getTabs().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (DBGeneratorOptions.this.view.getTabs().getSelectedIndex() == 0) {
                    DBGeneratorOptions.this.refreshGeneratorAction();
                }
            }
        });
    }

    protected void prepareGenerator() {
        try {
            DbAdapter adapter = this.connectionInfo.makeAdapter(this.getApplication().getClassLoadingService());
            this.generator = new DbGenerator(adapter, this.dataMap, this.tables.getExcludedTables());
        }
        catch (Exception ex) {
            this.reportError("Error loading adapter", ex);
        }
    }

    protected void createSQL() {
        String lineEnd;
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = this.generator.configuredStatements().iterator();
        String batchTerminator = this.generator.getAdapter().getBatchTerminator();
        String string = lineEnd = batchTerminator != null ? "\n" + batchTerminator + "\n\n" : "\n\n";
        while (it.hasNext()) {
            buf.append((Object)it.next()).append(lineEnd);
        }
        this.textForSQL = buf.toString();
    }

    protected void refreshView() {
        this.getView().setEnabled(this.connectionInfo != null);
        for (ObjectBinding optionBinding : this.optionBindings) {
            optionBinding.updateView();
        }
        this.sqlBinding.updateView();
    }

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public void refreshGeneratorAction() {
        this.prepareGenerator();
        this.refreshSQLAction();
    }

    public void refreshSQLAction() {
        this.adapterBinding.updateView();
        this.connectionInfo.setDbAdapter((String)this.view.getAdapters().getSelectedItem());
        this.prepareGenerator();
        this.generatorDefaults.configureGenerator(this.generator);
        this.createSQL();
        this.sqlBinding.updateView();
    }

    public void generateSchemaAction() {
        DataSourceWizard connectWizard = new DataSourceWizard(this.getParent(), "Generate DB Schema: Connect to Database", null, null);
        if (!connectWizard.startupAction()) {
            return;
        }
        this.connectionInfo = connectWizard.getConnectionInfo();
        this.refreshGeneratorAction();
        if (this.generator.isEmpty(true)) {
            JOptionPane.showMessageDialog(this.getView(), "Nothing to generate.");
            return;
        }
        try {
            DataSource dataSource = this.connectionInfo.makeDataSource(this.getApplication().getClassLoadingService());
            this.generator.runGenerator(dataSource);
            ValidationResult failures = this.generator.getFailures();
            if (failures == null || !failures.hasFailures()) {
                JOptionPane.showMessageDialog(this.getView(), "Schema Generation Complete.");
            } else {
                new ValidationResultBrowser(this).startupAction("Schema Generation Complete", "Schema generation finished. The following problem(s) were ignored.", failures);
            }
        }
        catch (Throwable th) {
            this.reportError("Schema Generation Error", th);
        }
    }

    public void storeSQLAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        fc.setDialogTitle("Save SQL Script");
        File projectDir = new File(this.getApplication().getProject().getConfigurationResource().getURL().getPath());
        if (projectDir != null) {
            fc.setCurrentDirectory(projectDir);
        }
        if (fc.showSaveDialog(this.getView()) == 0) {
            this.refreshGeneratorAction();
            try {
                File file = fc.getSelectedFile();
                FileWriter fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                pw.print(this.textForSQL);
                pw.flush();
                pw.close();
            }
            catch (IOException ex) {
                this.reportError("Error Saving SQL", ex);
            }
        }
    }

    public void closeAction() {
        this.view.dispose();
    }

    public DBConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(DBConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.refreshView();
    }
}

