/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.pref.RenamedPreferences;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;

public class SaveAction
extends SaveAsAction {
    public static String getActionName() {
        return "Save";
    }

    public SaveAction(Application application) {
        super(SaveAction.getActionName(), application);
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public String getIconName() {
        return "icon-save.gif";
    }

    protected boolean saveAll() throws Exception {
        Project p = this.getCurrentProject();
        if (p == null || p.getConfigurationResource() == null) {
            return super.saveAll();
        }
        String oldPath = p.getConfigurationResource().getURL().getPath();
        this.getProjectController().getProjectWatcher().pauseWatching();
        ProjectSaver saver = this.getApplication().getInjector().getInstance(ProjectSaver.class);
        saver.save(p);
        RenamedPreferences.removeOldPreferences();
        String[] path = oldPath.split("/");
        String[] newPath = p.getConfigurationResource().getURL().getPath().split("/");
        if (!path[path.length - 1].equals(newPath[newPath.length - 1])) {
            String newName = newPath[newPath.length - 1].replace(".xml", "");
            RenamedPreferences.copyPreferences(newName, this.getProjectController().getPreferenceForProject());
            RenamedPreferences.removeOldPreferences();
        }
        this.getApplication().getFrameController().changePathInLastProjListAction(oldPath, p.getConfigurationResource().getURL().getPath());
        Application.getFrame().fireRecentFileListChanged();
        this.getProjectController().getProjectWatcher().reconfigure();
        return true;
    }
}

