/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTBetween
extends ConditionNode {
    ASTBetween(int id) {
        super(id);
    }

    public ASTBetween() {
        super(15);
    }

    public ASTBetween(ASTPath path, Object value1, Object value2) {
        super(15);
        this.jjtAddChild(path, 0);
        this.jjtAddChild(new ASTScalar(value1), 1);
        this.jjtAddChild(new ASTScalar(value2), 2);
        this.connectChildren();
    }

    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len != 3) {
            return Boolean.FALSE;
        }
        Comparable c1 = ConversionUtil.toComparable(this.evaluateChild(0, o));
        if (c1 == null) {
            return Boolean.FALSE;
        }
        Comparable c2 = ConversionUtil.toComparable(this.evaluateChild(1, o));
        if (c2 == null) {
            return Boolean.FALSE;
        }
        Comparable c3 = ConversionUtil.toComparable(this.evaluateChild(2, o));
        if (c3 == null) {
            return Boolean.FALSE;
        }
        return c1.compareTo(c2) >= 0 && c1.compareTo(c3) <= 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Expression shallowCopy() {
        return new ASTBetween(this.id);
    }

    protected String getExpressionOperator(int index) {
        return index == 2 ? "and" : "between";
    }

    public int getType() {
        return 9;
    }
}

