/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Capture changes from an SQL Server database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumSqlserverEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Debezium SQL Server Connector component.
     */
    public interface DebeziumSqlserverEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumSqlserverEndpointBuilder advanced() {
            return (AdvancedDebeziumSqlserverEndpointBuilder) this;
        }

        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro. This is a multi-value option with prefix: additionalProperties.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder additionalProperties(String key, Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro. This is a multi-value option with prefix: additionalProperties.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder internalKeyConverter(String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder internalValueConverter(String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetCommitPolicy(String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetCommitTimeoutMs(String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetFlushIntervalMs(long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetFlushIntervalMs(String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStorage(String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageFileName(String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStoragePartitions(int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStoragePartitions(String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageReplicationFactor(String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageTopic(String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Specify how binary (blob, binary, etc.) columns should be represented
         * in change events, including: 'bytes' represents binary data as byte
         * array (default); 'base64' represents binary data as base64-encoded
         * string; 'base64-url-safe' represents binary data as
         * base64-url-safe-encoded string; 'hex' represents binary data as
         * hex-encoded (base16) string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: bytes
         * Group: sqlserver
         * 
         * @param binaryHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder binaryHandlingMode(String binaryHandlingMode) {
            doSetProperty("binaryHandlingMode", binaryHandlingMode);
            return this;
        }
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder columnExcludeList(String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder columnIncludeList(String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder columnPropagateSourceType(String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
        /**
         * The maximum time in milliseconds to wait for connection validation to
         * complete. Defaults to 60 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1m
         * Group: sqlserver
         * 
         * @param connectionValidationTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder connectionValidationTimeoutMs(long connectionValidationTimeoutMs) {
            doSetProperty("connectionValidationTimeoutMs", connectionValidationTimeoutMs);
            return this;
        }
        /**
         * The maximum time in milliseconds to wait for connection validation to
         * complete. Defaults to 60 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1m
         * Group: sqlserver
         * 
         * @param connectionValidationTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder connectionValidationTimeoutMs(String connectionValidationTimeoutMs) {
            doSetProperty("connectionValidationTimeoutMs", connectionValidationTimeoutMs);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder converters(String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder customMetricTags(String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
        /**
         * Regular expression identifying configuration keys whose values should
         * be masked. When set, this custom pattern replaces Debeziums default
         * password masking pattern.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * .*secret$|.*password$|.*sasl\.jaas\.config$|.*basic\.auth\.user\.info|.*registry\.auth\.client-secret
         * Group: sqlserver
         * 
         * @param customSanitizePattern the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder customSanitizePattern(String customSanitizePattern) {
            doSetProperty("customSanitizePattern", customSanitizePattern);
            return this;
        }
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databaseHostname(String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
        /**
         * The SQL Server instance name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param databaseInstance the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databaseInstance(String databaseInstance) {
            doSetProperty("databaseInstance", databaseInstance);
            return this;
        }
        /**
         * The names of the databases from which the connector should capture
         * changes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param databaseNames the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databaseNames(String databaseNames) {
            doSetProperty("databaseNames", databaseNames);
            return this;
        }
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: sqlserver
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databasePassword(String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1433
         * Group: sqlserver
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1433
         * Group: sqlserver
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databasePort(String databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Time to wait for a query to execute, given in milliseconds. Defaults
         * to 600 seconds (600,000 ms); zero means there is no limit.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10m
         * Group: sqlserver
         * 
         * @param databaseQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databaseQueryTimeoutMs(int databaseQueryTimeoutMs) {
            doSetProperty("databaseQueryTimeoutMs", databaseQueryTimeoutMs);
            return this;
        }
        /**
         * Time to wait for a query to execute, given in milliseconds. Defaults
         * to 600 seconds (600,000 ms); zero means there is no limit.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10m
         * Group: sqlserver
         * 
         * @param databaseQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databaseQueryTimeoutMs(String databaseQueryTimeoutMs) {
            doSetProperty("databaseQueryTimeoutMs", databaseQueryTimeoutMs);
            return this;
        }
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder databaseUser(String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
        /**
         * Controls how the connector queries CDC data. The default is 'direct',
         * which makes the connector to query the change tables directly. The
         * value of 'function' means the data is queried by means of calling
         * cdc.fn_cdc_get_all_changes_# function.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: direct
         * Group: sqlserver
         * 
         * @param dataQueryMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder dataQueryMode(String dataQueryMode) {
            doSetProperty("dataQueryMode", dataQueryMode);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder datatypePropagateSourceType(String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including: 'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: precise
         * Group: sqlserver
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder decimalHandlingMode(String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: sqlserver
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder errorsMaxRetries(int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: sqlserver
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder errorsMaxRetries(String errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: fail
         * Group: sqlserver
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder eventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * The maximum time in milliseconds to wait for task executor to shut
         * down.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 4s
         * Group: sqlserver
         * 
         * @param executorShutdownTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder executorShutdownTimeoutMs(long executorShutdownTimeoutMs) {
            doSetProperty("executorShutdownTimeoutMs", executorShutdownTimeoutMs);
            return this;
        }
        /**
         * The maximum time in milliseconds to wait for task executor to shut
         * down.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 4s
         * Group: sqlserver
         * 
         * @param executorShutdownTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder executorShutdownTimeoutMs(String executorShutdownTimeoutMs) {
            doSetProperty("executorShutdownTimeoutMs", executorShutdownTimeoutMs);
            return this;
        }
        /**
         * Enable/Disable Debezium context headers that provides essential
         * metadata for tracking and identifying the source of CDC events in
         * downstream processing systems.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param extendedHeadersEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder extendedHeadersEnabled(boolean extendedHeadersEnabled) {
            doSetProperty("extendedHeadersEnabled", extendedHeadersEnabled);
            return this;
        }
        /**
         * Enable/Disable Debezium context headers that provides essential
         * metadata for tracking and identifying the source of CDC events in
         * downstream processing systems.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param extendedHeadersEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder extendedHeadersEnabled(String extendedHeadersEnabled) {
            doSetProperty("extendedHeadersEnabled", extendedHeadersEnabled);
            return this;
        }
        /**
         * Specify the action to take when a guardrail collections limit is
         * exceeded: 'warn' (the default) logs a warning message and continues
         * processing; 'fail' stops the connector with an error.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: warn
         * Group: sqlserver
         * 
         * @param guardrailCollectionsLimitAction the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder guardrailCollectionsLimitAction(String guardrailCollectionsLimitAction) {
            doSetProperty("guardrailCollectionsLimitAction", guardrailCollectionsLimitAction);
            return this;
        }
        /**
         * The maximum number of collections or tables that can be captured by
         * the connector. When this limit is exceeded, the action specified by
         * 'guardrail.collections.limit.action' will be taken. Set to 0 to
         * disable this guardrail.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: sqlserver
         * 
         * @param guardrailCollectionsMax the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder guardrailCollectionsMax(int guardrailCollectionsMax) {
            doSetProperty("guardrailCollectionsMax", guardrailCollectionsMax);
            return this;
        }
        /**
         * The maximum number of collections or tables that can be captured by
         * the connector. When this limit is exceeded, the action specified by
         * 'guardrail.collections.limit.action' will be taken. Set to 0 to
         * disable this guardrail.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: sqlserver
         * 
         * @param guardrailCollectionsMax the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder guardrailCollectionsMax(String guardrailCollectionsMax) {
            doSetProperty("guardrailCollectionsMax", guardrailCollectionsMax);
            return this;
        }
        /**
         * The query executed with every heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param heartbeatActionQuery the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder heartbeatActionQuery(String heartbeatActionQuery) {
            doSetProperty("heartbeatActionQuery", heartbeatActionQuery);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder heartbeatIntervalMs(int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder heartbeatIntervalMs(String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: __debezium-heartbeat
         * Group: sqlserver
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder heartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder includeSchemaChanges(boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder includeSchemaChanges(String includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder includeSchemaComments(boolean includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder includeSchemaComments(String includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
        /**
         * Detect schema change during an incremental snapshot and re-select a
         * current chunk to avoid locking DDLs. Note that changes to a primary
         * key are not supported and can cause incorrect results if performed
         * during an incremental snapshot. Another limitation is that if a
         * schema change affects only columns' default values, then the change
         * won't be detected until the DDL is processed from the binlog stream.
         * This doesn't affect the snapshot events' values, but the schema of
         * snapshot events may have outdated defaults.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param incrementalSnapshotAllowSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotAllowSchemaChanges(boolean incrementalSnapshotAllowSchemaChanges) {
            doSetProperty("incrementalSnapshotAllowSchemaChanges", incrementalSnapshotAllowSchemaChanges);
            return this;
        }
        /**
         * Detect schema change during an incremental snapshot and re-select a
         * current chunk to avoid locking DDLs. Note that changes to a primary
         * key are not supported and can cause incorrect results if performed
         * during an incremental snapshot. Another limitation is that if a
         * schema change affects only columns' default values, then the change
         * won't be detected until the DDL is processed from the binlog stream.
         * This doesn't affect the snapshot events' values, but the schema of
         * snapshot events may have outdated defaults.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param incrementalSnapshotAllowSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotAllowSchemaChanges(String incrementalSnapshotAllowSchemaChanges) {
            doSetProperty("incrementalSnapshotAllowSchemaChanges", incrementalSnapshotAllowSchemaChanges);
            return this;
        }
        /**
         * The maximum size of chunk (number of documents/rows) for incremental
         * snapshotting.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1024
         * Group: sqlserver
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
        /**
         * The maximum size of chunk (number of documents/rows) for incremental
         * snapshotting.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1024
         * Group: sqlserver
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotChunkSize(String incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
        /**
         * Add OPTION(RECOMPILE) on each SELECT statement during the incremental
         * snapshot process. This prevents parameter sniffing but can cause CPU
         * pressure on the source database.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param incrementalSnapshotOptionRecompile the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotOptionRecompile(boolean incrementalSnapshotOptionRecompile) {
            doSetProperty("incrementalSnapshotOptionRecompile", incrementalSnapshotOptionRecompile);
            return this;
        }
        /**
         * Add OPTION(RECOMPILE) on each SELECT statement during the incremental
         * snapshot process. This prevents parameter sniffing but can cause CPU
         * pressure on the source database.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param incrementalSnapshotOptionRecompile the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotOptionRecompile(String incrementalSnapshotOptionRecompile) {
            doSetProperty("incrementalSnapshotOptionRecompile", incrementalSnapshotOptionRecompile);
            return this;
        }
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: INSERT_INSERT
         * Group: sqlserver
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder incrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: sqlserver
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: sqlserver
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxBatchSize(String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * This property can be used to reduce the connector memory usage
         * footprint when changes are streamed from multiple tables per
         * database.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500
         * Group: sqlserver
         * 
         * @param maxIterationTransactions the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxIterationTransactions(int maxIterationTransactions) {
            doSetProperty("maxIterationTransactions", maxIterationTransactions);
            return this;
        }
        /**
         * This property can be used to reduce the connector memory usage
         * footprint when changes are streamed from multiple tables per
         * database.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 500
         * Group: sqlserver
         * 
         * @param maxIterationTransactions the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxIterationTransactions(String maxIterationTransactions) {
            doSetProperty("maxIterationTransactions", maxIterationTransactions);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8192
         * Group: sqlserver
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8192
         * Group: sqlserver
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxQueueSize(String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: sqlserver
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: sqlserver
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder maxQueueSizeInBytes(String maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':', where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector, and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key. Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder messageKeyColumns(String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder notificationEnabledChannels(String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder notificationSinkTopicName(String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
        /**
         * Path to OpenLineage file configuration. See
         * https://openlineage.io/docs/client/java/configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ./openlineage.yml
         * Group: sqlserver
         * 
         * @param openlineageIntegrationConfigFilePath the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationConfigFilePath(String openlineageIntegrationConfigFilePath) {
            doSetProperty("openlineageIntegrationConfigFilePath", openlineageIntegrationConfigFilePath);
            return this;
        }
        /**
         * The Kafka bootstrap server address used as input/output namespace/.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param openlineageIntegrationDatasetKafkaBootstrapServers the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationDatasetKafkaBootstrapServers(String openlineageIntegrationDatasetKafkaBootstrapServers) {
            doSetProperty("openlineageIntegrationDatasetKafkaBootstrapServers", openlineageIntegrationDatasetKafkaBootstrapServers);
            return this;
        }
        /**
         * Enable Debezium to emit data lineage metadata through OpenLineage
         * API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param openlineageIntegrationEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationEnabled(boolean openlineageIntegrationEnabled) {
            doSetProperty("openlineageIntegrationEnabled", openlineageIntegrationEnabled);
            return this;
        }
        /**
         * Enable Debezium to emit data lineage metadata through OpenLineage
         * API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param openlineageIntegrationEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationEnabled(String openlineageIntegrationEnabled) {
            doSetProperty("openlineageIntegrationEnabled", openlineageIntegrationEnabled);
            return this;
        }
        /**
         * The job's description emitted by Debezium.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Debezium change data capture job
         * Group: sqlserver
         * 
         * @param openlineageIntegrationJobDescription the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationJobDescription(String openlineageIntegrationJobDescription) {
            doSetProperty("openlineageIntegrationJobDescription", openlineageIntegrationJobDescription);
            return this;
        }
        /**
         * The job's namespace emitted by Debezium.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param openlineageIntegrationJobNamespace the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationJobNamespace(String openlineageIntegrationJobNamespace) {
            doSetProperty("openlineageIntegrationJobNamespace", openlineageIntegrationJobNamespace);
            return this;
        }
        /**
         * The job's owners emitted by Debezium. A comma-separated list of
         * key-value pairs.For example: k1=v1,k2=v2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param openlineageIntegrationJobOwners the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationJobOwners(String openlineageIntegrationJobOwners) {
            doSetProperty("openlineageIntegrationJobOwners", openlineageIntegrationJobOwners);
            return this;
        }
        /**
         * The job's tags emitted by Debezium. A comma-separated list of
         * key-value pairs.For example: k1=v1,k2=v2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param openlineageIntegrationJobTags the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder openlineageIntegrationJobTags(String openlineageIntegrationJobTags) {
            doSetProperty("openlineageIntegrationJobTags", openlineageIntegrationJobTags);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500ms
         * Group: sqlserver
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500ms
         * Group: sqlserver
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder pollIntervalMs(String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder postProcessors(String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder provideTransactionMetadata(boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder provideTransactionMetadata(String provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: sqlserver
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder retriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: sqlserver
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder retriableRestartConnectorWaitMs(String retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * The name of the SchemaHistory class that should be used to store and
         * recover database schema changes. The configuration properties for the
         * history are prefixed with the 'schema.history.internal.' string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.storage.kafka.history.KafkaSchemaHistory
         * Group: sqlserver
         * 
         * @param schemaHistoryInternal the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternal(String schemaHistoryInternal) {
            doSetProperty("schemaHistoryInternal", schemaHistoryInternal);
            return this;
        }
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalSkipUnparseableDdl(boolean schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalSkipUnparseableDdl(String schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a table from captured
         * schema/database will be stored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a table from captured
         * schema/database will be stored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(String schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(String schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: sqlserver
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder schemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. For multi-partition mode connectors, multiple signal
         * data collections can be specified as a comma-separated list.
         * Signaling is disabled when not set.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder signalDataCollection(String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: source
         * Group: sqlserver
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder signalEnabledChannels(String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5s
         * Group: sqlserver
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder signalPollIntervalMs(long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5s
         * Group: sqlserver
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder signalPollIntervalMs(String signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: t
         * Group: sqlserver
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder skippedOperations(String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotDelayMs(String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotFetchSize(int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotFetchSize(String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
        /**
         * Controls which transaction isolation level is used and how long the
         * connector locks the captured tables. The default is
         * 'repeatable_read', which means that repeatable read isolation level
         * is used. In addition, type of acquired lock during schema snapshot
         * depends on snapshot.locking.mode property. Using a value of
         * 'exclusive' ensures that the connector holds the type of lock
         * specified with snapshot.locking.mode property (and thus prevents any
         * reads and updates) for all captured tables during the entire snapshot
         * duration. When 'snapshot' is specified, connector runs the initial
         * snapshot in SNAPSHOT isolation level, which guarantees snapshot
         * consistency. In addition, neither table nor row-level locks are held.
         * When 'read_committed' is specified, connector runs the initial
         * snapshot in READ COMMITTED isolation level. No long-running locks are
         * taken, so that initial snapshot does not prevent other transactions
         * from updating table rows. Snapshot consistency is not guaranteed.In
         * 'read_uncommitted' mode neither table nor row-level locks are
         * acquired, but connector does not guarantee snapshot consistency.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: repeatable_read
         * Group: sqlserver
         * 
         * @param snapshotIsolationMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotIsolationMode(String snapshotIsolationMode) {
            doSetProperty("snapshotIsolationMode", snapshotIsolationMode);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: sqlserver
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: sqlserver
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotLockTimeoutMs(String snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: sqlserver
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotMaxThreads(int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: sqlserver
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotMaxThreads(String snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'initial' (default): If
         * the connector does not detect any offsets for the logical server
         * name, it runs a snapshot that captures the current full state of the
         * configured tables. After the snapshot completes, the connector begins
         * to stream changes from the transaction log.; 'initial_only': The
         * connector performs a snapshot as it does for the 'initial' option,
         * but after the connector completes the snapshot, it stops, and does
         * not stream changes from the transaction log.; 'schema_only': If the
         * connector does not detect any offsets for the logical server name, it
         * runs a snapshot that captures only the schema (table structures), but
         * not any table data. After the snapshot completes, the connector
         * begins to stream changes from the transaction log.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: initial
         * Group: sqlserver
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotMode(String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotData(String snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotOnDataError(String snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(String snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedSnapshotSchema(String snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeConfigurationBasedStartStream(String snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as custom, this setting must be set to
         * specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the 'Snapshotter'
         * interface and is called on each app boot to determine whether to do a
         * snapshot.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotModeCustomName(String snapshotModeCustomName) {
            doSetProperty("snapshotModeCustomName", snapshotModeCustomName);
            return this;
        }
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * the specific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
        /**
         * Controls the order in which tables are processed in the initial
         * snapshot. A descending value will order the tables by row count
         * descending. A ascending value will order the tables by row count
         * ascending. A value of disabled (the default) will disable ordering by
         * row count.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: disabled
         * Group: sqlserver
         * 
         * @param snapshotTablesOrderByRowCount the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder snapshotTablesOrderByRowCount(String snapshotTablesOrderByRowCount) {
            doSetProperty("snapshotTablesOrderByRowCount", snapshotTablesOrderByRowCount);
            return this;
        }
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * io.debezium.connector.sqlserver.SqlServerSourceInfoStructMaker
         * Group: sqlserver
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder sourceinfoStructMaker(String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder streamingDelayMs(long streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder streamingDelayMs(String streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
        /**
         * Specifies the maximum number of rows that should be read in one go
         * from each table while streaming. The connector will read the table
         * contents in multiple batches of this size. Defaults to 0 which means
         * no limit.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: sqlserver
         * 
         * @param streamingFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder streamingFetchSize(int streamingFetchSize) {
            doSetProperty("streamingFetchSize", streamingFetchSize);
            return this;
        }
        /**
         * Specifies the maximum number of rows that should be read in one go
         * from each table while streaming. The connector will read the table
         * contents in multiple batches of this size. Defaults to 0 which means
         * no limit.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: sqlserver
         * 
         * @param streamingFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder streamingFetchSize(String streamingFetchSize) {
            doSetProperty("streamingFetchSize", streamingFetchSize);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder tableExcludeList(String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder tableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder tableIgnoreBuiltin(String tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder tableIncludeList(String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including: 'adaptive' (the default) bases the precision
         * of time, date, and timestamp values on the database column's
         * precision; 'adaptive_time_microseconds' like 'adaptive' mode, but
         * TIME fields always use microseconds precision; 'connect' always
         * represents time, date, and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: adaptive
         * Group: sqlserver
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder timePrecisionMode(String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder tombstonesOnDelete(boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder tombstonesOnDelete(String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: sqlserver
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder topicNamingStrategy(String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: sqlserver
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder topicPrefix(String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
        /**
         * Class to make transaction context &amp; transaction struct/schemas.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory
         * Group: sqlserver
         * 
         * @param transactionMetadataFactory the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder transactionMetadataFactory(String transactionMetadataFactory) {
            doSetProperty("transactionMetadataFactory", transactionMetadataFactory);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium SQL Server Connector component.
     */
    public interface AdvancedDebeziumSqlserverEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumSqlserverEndpointBuilder basic() {
            return (DebeziumSqlserverEndpointBuilder) this;
        }

        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumSqlserverEndpointBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumSqlserverEndpointBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface DebeziumSqlserverBuilders {
        /**
         * Debezium SQL Server Connector (camel-debezium-sqlserver)
         * Capture changes from an SQL Server database.
         * 
         * Category: database
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
         * 
         * @return the dsl builder for the headers' name.
         */
        default DebeziumSqlserverHeaderNameBuilder debeziumSqlserver() {
            return DebeziumSqlserverHeaderNameBuilder.INSTANCE;
        }
        /**
         * Debezium SQL Server Connector (camel-debezium-sqlserver)
         * Capture changes from an SQL Server database.
         * 
         * Category: database
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
         * 
         * Syntax: <code>debezium-sqlserver:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param path name
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder debeziumSqlserver(String path) {
            return DebeziumSqlserverEndpointBuilderFactory.endpointBuilder("debezium-sqlserver", path);
        }
        /**
         * Debezium SQL Server Connector (camel-debezium-sqlserver)
         * Capture changes from an SQL Server database.
         * 
         * Category: database
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
         * 
         * Syntax: <code>debezium-sqlserver:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default DebeziumSqlserverEndpointBuilder debeziumSqlserver(String componentName, String path) {
            return DebeziumSqlserverEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Debezium SQL Server Connector component.
     */
    public static class DebeziumSqlserverHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DebeziumSqlserverHeaderNameBuilder INSTANCE = new DebeziumSqlserverHeaderNameBuilder();

        /**
         * The metadata about the source event, for example table name, database
         * name, log position, etc, please refer to the Debezium documentation
         * for more info.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumSourceMetadata}.
         */
        public String debeziumSourceMetadata() {
            return "CamelDebeziumSourceMetadata";
        }
        /**
         * The identifier of the connector, normally is this format
         * {server-name}.{database-name}.{table-name}.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumIdentifier}.
         */
        public String debeziumIdentifier() {
            return "CamelDebeziumIdentifier";
        }
        /**
         * The key of the event, normally is the table Primary Key.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumKey}.
         */
        public String debeziumKey() {
            return "CamelDebeziumKey";
        }
        /**
         * If presents, the type of event operation. Values for the connector
         * are c for create (or insert), u for update, d for delete or r for
         * read (in the case of a initial sync) or in case of a snapshot event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumOperation}.
         */
        public String debeziumOperation() {
            return "CamelDebeziumOperation";
        }
        /**
         * If presents, the time (using the system clock in the JVM) at which
         * the connector processed the event.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumTimestamp}.
         */
        public String debeziumTimestamp() {
            return "CamelDebeziumTimestamp";
        }
        /**
         * If presents, contains the state of the row before the event occurred.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumBefore}.
         */
        public String debeziumBefore() {
            return "CamelDebeziumBefore";
        }
        /**
         * If presents, the ddl sql text of the event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumDdlSQL}.
         */
        public String debeziumDdlSQL() {
            return "CamelDebeziumDdlSQL";
        }
    }
    static DebeziumSqlserverEndpointBuilder endpointBuilder(String componentName, String path) {
        class DebeziumSqlserverEndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumSqlserverEndpointBuilder, AdvancedDebeziumSqlserverEndpointBuilder {
            public DebeziumSqlserverEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DebeziumSqlserverEndpointBuilderImpl(path);
    }
}