/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.osgi.karaf;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.osgi.karaf.KarafContainerImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Karaf", description="Apache Karaf is a small OSGi based runtime which provides a lightweight container onto which various components and applications can be deployed.", iconUrl="classpath:///karaf-logo.png")
@ImplementedBy(value=KarafContainerImpl.class)
public interface KarafContainer
extends SoftwareProcess,
UsesJava,
UsesJmx {
    public static final String WRAP_SCHEME = "wrap";
    public static final String FILE_SCHEME = "file";
    public static final String MVN_SCHEME = "mvn";
    public static final String HTTP_SCHEME = "http";
    public static final MethodEffector<Map<Long, Map<String, ?>>> LIST_BUNDLES = new MethodEffector(KarafContainer.class, "listBundles");
    public static final MethodEffector<Long> INSTALL_BUNDLE = new MethodEffector(KarafContainer.class, "installBundle");
    public static final MethodEffector<Void> UNINSTALL_BUNDLE = new MethodEffector(KarafContainer.class, "uninstallBundle");
    public static final MethodEffector<Void> INSTALL_FEATURE = new MethodEffector(KarafContainer.class, "installFeature");
    public static final MethodEffector<Void> UPDATE_SERVICE_PROPERTIES = new MethodEffector(KarafContainer.class, "updateServiceProperties");
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"2.3.0");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"apache-karaf-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://apache.mirror.anlx.net/karaf/${version}/apache-karaf-${version}.tar.gz");
    @SetFromFlag(value="karafName")
    public static final AttributeSensorAndConfigKey<String, String> KARAF_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"karaf.name", (String)"Karaf instance name", (String)"root");
    public static final MapConfigKey<Map<String, String>> NAMED_PROPERTY_FILES = new MapConfigKey(Map.class, "karaf.runtime.files", "Property files to be generated, referenced by name relative to runDir");
    @SetFromFlag(value="jmxUser")
    public static final AttributeSensorAndConfigKey<String, String> JMX_USER = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)UsesJmx.JMX_USER, (Object)"karaf");
    @SetFromFlag(value="jmxPassword")
    public static final AttributeSensorAndConfigKey<String, String> JMX_PASSWORD = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)UsesJmx.JMX_PASSWORD, (Object)"karaf");
    @SetFromFlag(value="jmxPort")
    public static final PortAttributeSensorAndConfigKey JMX_PORT = ConfigKeys.newPortSensorAndConfigKeyWithDefault((PortAttributeSensorAndConfigKey)UsesJmx.JMX_PORT, (Object)"44444+");
    @SetFromFlag(value="rmiRegistryPort")
    public static final PortAttributeSensorAndConfigKey RMI_REGISTRY_PORT = UsesJmx.RMI_REGISTRY_PORT;
    @SetFromFlag(value="jmxContext")
    public static final AttributeSensorAndConfigKey<String, String> JMX_CONTEXT = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)UsesJmx.JMX_CONTEXT, (Object)("karaf-" + (String)KARAF_NAME.getConfigKey().getDefaultValue()));
    public static final AttributeSensor<Map> KARAF_INSTANCES = Sensors.newSensor(Map.class, (String)"karaf.admin.instances", (String)"Karaf admin instances");
    public static final AttributeSensor<Boolean> KARAF_ROOT = Sensors.newBooleanSensor((String)"karaf.admin.isRoot", (String)"Karaf admin isRoot");
    public static final AttributeSensor<String> KARAF_JAVA_OPTS = Sensors.newStringSensor((String)"karaf.admin.java_opts", (String)"Karaf Java opts");
    public static final AttributeSensor<String> KARAF_INSTALL_LOCATION = Sensors.newStringSensor((String)"karaf.admin.location", (String)"Karaf install location");
    public static final AttributeSensor<Integer> KARAF_PID = Sensors.newIntegerSensor((String)"karaf.admin.pid", (String)"Karaf instance PID");
    public static final AttributeSensor<Integer> KARAF_SSH_PORT = Sensors.newIntegerSensor((String)"karaf.admin.ssh_port", (String)"Karaf SSH Port");
    public static final AttributeSensor<Integer> KARAF_RMI_REGISTRY_PORT = Sensors.newIntegerSensor((String)"karaf.admin.rmi_registry_port", (String)"Karaf instance RMI registry port");
    public static final AttributeSensor<Integer> KARAF_RMI_SERVER_PORT = Sensors.newIntegerSensor((String)"karaf.admin.rmi_server_port", (String)"Karaf RMI (JMX) server port");
    public static final AttributeSensor<String> KARAF_STATE = Sensors.newStringSensor((String)"karaf.admin.state", (String)"Karaf instance state");

    @Effector(description="Updates the OSGi Service's properties, adding (and overriding) the given key-value pairs")
    public void updateServiceProperties(@EffectorParam(name="serviceName", description="Name of the OSGi service") String var1, Map<String, String> var2);

    @Effector(description="Installs the given OSGi feature")
    public void installFeature(@EffectorParam(name="featureName", description="Name of the feature - see org.apache.karaf:type=features#installFeature()") String var1) throws Exception;

    @Effector(description="Lists all the karaf bundles")
    public Map<Long, Map<String, ?>> listBundles();

    @Effector(description="Deploys the given bundle, returning the bundle id - see osgi.core:type=framework#installBundle()")
    public long installBundle(@EffectorParam(name="bundle", description="URI of bundle to be deployed") String var1) throws URISyntaxException;

    @Effector(description="Undeploys the bundle with the given id")
    public void uninstallBundle(@EffectorParam(name="bundleId", description="Id of the bundle") Long var1);
}

