/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.effector.EffectorBase;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.EffectorWithBody;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicSequentialTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEffector<T>
extends EffectorBase<T>
implements EffectorWithBody<T> {
    private static final long serialVersionUID = 1832435915652457843L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEffector.class);

    public AbstractEffector(String name, Class<T> returnType, List<ParameterType<?>> parameters, String description) {
        super(name, returnType, parameters, description);
    }

    public abstract T call(Entity var1, Map var2);

    public T call(Entity entity) {
        return this.call((Map)ImmutableMap.of(), entity);
    }

    public T call(Map parameters, Entity entity) {
        return this.call(entity, parameters);
    }

    protected Map<Object, Object> getFlagsForTaskInvocationAt(Entity entity, Effector<T> effector, ConfigBag parameters) {
        return EffectorUtils.getTaskFlagsForEffectorInvocation(entity, effector, parameters);
    }

    @Override
    public final EffectorTasks.EffectorTaskFactory<T> getBody() {
        return new EffectorTasks.EffectorTaskFactory<T>(){

            @Override
            public Task<T> newTask(final Entity entity, Effector<T> effector, final ConfigBag parameters) {
                return new DynamicSequentialTask(AbstractEffector.this.getFlagsForTaskInvocationAt(entity, AbstractEffector.this, parameters), new Callable<T>(){

                    @Override
                    public T call() {
                        return AbstractEffector.this.call(parameters.getAllConfig(), entity);
                    }
                });
            }
        };
    }
}

