/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSource;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource;
import io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeSpecFluent<A> {
    private List<String> accessModes = new ArrayList<String>();
    private VisitableBuilder<? extends AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    private VisitableBuilder<? extends AzureFileVolumeSource, ?> azureFile;
    private Map<String, Quantity> capacity = new LinkedHashMap<String, Quantity>();
    private VisitableBuilder<? extends CephFSVolumeSource, ?> cephfs;
    private VisitableBuilder<? extends CinderVolumeSource, ?> cinder;
    private VisitableBuilder<? extends ObjectReference, ?> claimRef;
    private VisitableBuilder<? extends FCVolumeSource, ?> fc;
    private VisitableBuilder<? extends FlexVolumeSource, ?> flexVolume;
    private VisitableBuilder<? extends FlockerVolumeSource, ?> flocker;
    private VisitableBuilder<? extends GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    private VisitableBuilder<? extends GlusterfsVolumeSource, ?> glusterfs;
    private VisitableBuilder<? extends HostPathVolumeSource, ?> hostPath;
    private VisitableBuilder<? extends ISCSIVolumeSource, ?> iscsi;
    private VisitableBuilder<? extends NFSVolumeSource, ?> nfs;
    private String persistentVolumeReclaimPolicy;
    private VisitableBuilder<? extends RBDVolumeSource, ?> rbd;
    private VisitableBuilder<? extends VsphereVirtualDiskVolumeSource, ?> vsphereVolume;

    public PersistentVolumeSpecFluentImpl() {
    }

    public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureFile(instance.getAzureFile());
        this.withCapacity(instance.getCapacity());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withClaimRef(instance.getClaimRef());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
        this.withRbd(instance.getRbd());
        this.withVsphereVolume(instance.getVsphereVolume());
    }

    @Override
    public A addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    @Override
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this._visitables.remove(this.awsElasticBlockStore);
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore() != null ? this.getAwsElasticBlockStore() : new AWSElasticBlockStoreVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore() != null ? this.getAwsElasticBlockStore() : item);
    }

    @Override
    public A withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    @Override
    public AzureFileVolumeSource getAzureFile() {
        return this.azureFile != null ? (AzureFileVolumeSource)this.azureFile.build() : null;
    }

    @Override
    public A withAzureFile(AzureFileVolumeSource azureFile) {
        this._visitables.remove(this.azureFile);
        if (azureFile != null) {
            this.azureFile = new AzureFileVolumeSourceBuilder(azureFile);
            this._visitables.add(this.azureFile);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile() {
        return new AzureFileNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item) {
        return new AzureFileNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile());
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile() != null ? this.getAzureFile() : new AzureFileVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item) {
        return this.withNewAzureFileLike(this.getAzureFile() != null ? this.getAzureFile() : item);
    }

    @Override
    public A withNewAzureFile(Boolean readOnly, String secretName, String shareName) {
        return this.withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (A)this;
    }

    @Override
    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? (CephFSVolumeSource)this.cephfs.build() : null;
    }

    @Override
    public A withCephfs(CephFSVolumeSource cephfs) {
        this._visitables.remove(this.cephfs);
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs() {
        return new CephfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfs() {
        return this.withNewCephfsLike(this.getCephfs() != null ? this.getCephfs() : new CephFSVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item) {
        return this.withNewCephfsLike(this.getCephfs() != null ? this.getCephfs() : item);
    }

    @Override
    public CinderVolumeSource getCinder() {
        return this.cinder != null ? (CinderVolumeSource)this.cinder.build() : null;
    }

    @Override
    public A withCinder(CinderVolumeSource cinder) {
        this._visitables.remove(this.cinder);
        if (cinder != null) {
            this.cinder = new CinderVolumeSourceBuilder(cinder);
            this._visitables.add(this.cinder);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder() {
        return new CinderNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item) {
        return new CinderNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editCinder() {
        return this.withNewCinderLike(this.getCinder());
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinder() {
        return this.withNewCinderLike(this.getCinder() != null ? this.getCinder() : new CinderVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item) {
        return this.withNewCinderLike(this.getCinder() != null ? this.getCinder() : item);
    }

    @Override
    public A withNewCinder(String fsType, Boolean readOnly, String volumeID) {
        return this.withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    @Override
    public ObjectReference getClaimRef() {
        return this.claimRef != null ? (ObjectReference)this.claimRef.build() : null;
    }

    @Override
    public A withClaimRef(ObjectReference claimRef) {
        this._visitables.remove(this.claimRef);
        if (claimRef != null) {
            this.claimRef = new ObjectReferenceBuilder(claimRef);
            this._visitables.add(this.claimRef);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef() {
        return new ClaimRefNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item) {
        return new ClaimRefNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef());
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef() != null ? this.getClaimRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item) {
        return this.withNewClaimRefLike(this.getClaimRef() != null ? this.getClaimRef() : item);
    }

    @Override
    public FCVolumeSource getFc() {
        return this.fc != null ? (FCVolumeSource)this.fc.build() : null;
    }

    @Override
    public A withFc(FCVolumeSource fc) {
        this._visitables.remove(this.fc);
        if (fc != null) {
            this.fc = new FCVolumeSourceBuilder(fc);
            this._visitables.add(this.fc);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> withNewFc() {
        return new FcNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item) {
        return new FcNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editFc() {
        return this.withNewFcLike(this.getFc());
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFc() {
        return this.withNewFcLike(this.getFc() != null ? this.getFc() : new FCVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item) {
        return this.withNewFcLike(this.getFc() != null ? this.getFc() : item);
    }

    @Override
    public FlexVolumeSource getFlexVolume() {
        return this.flexVolume != null ? (FlexVolumeSource)this.flexVolume.build() : null;
    }

    @Override
    public A withFlexVolume(FlexVolumeSource flexVolume) {
        this._visitables.remove(this.flexVolume);
        if (flexVolume != null) {
            this.flexVolume = new FlexVolumeSourceBuilder(flexVolume);
            this._visitables.add(this.flexVolume);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume() {
        return new FlexVolumeNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item) {
        return new FlexVolumeNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume());
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume() != null ? this.getFlexVolume() : new FlexVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item) {
        return this.withNewFlexVolumeLike(this.getFlexVolume() != null ? this.getFlexVolume() : item);
    }

    @Override
    public FlockerVolumeSource getFlocker() {
        return this.flocker != null ? (FlockerVolumeSource)this.flocker.build() : null;
    }

    @Override
    public A withFlocker(FlockerVolumeSource flocker) {
        this._visitables.remove(this.flocker);
        if (flocker != null) {
            this.flocker = new FlockerVolumeSourceBuilder(flocker);
            this._visitables.add(this.flocker);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker() {
        return new FlockerNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
        return new FlockerNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker() {
        return this.withNewFlockerLike(this.getFlocker());
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlocker() {
        return this.withNewFlockerLike(this.getFlocker() != null ? this.getFlocker() : new FlockerVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item) {
        return this.withNewFlockerLike(this.getFlocker() != null ? this.getFlocker() : item);
    }

    @Override
    public A withNewFlocker(String datasetName) {
        return this.withFlocker(new FlockerVolumeSource(datasetName));
    }

    @Override
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    @Override
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this._visitables.remove(this.gcePersistentDisk);
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
        return new GcePersistentDiskNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk() != null ? this.getGcePersistentDisk() : new GCEPersistentDiskVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk() != null ? this.getGcePersistentDisk() : item);
    }

    @Override
    public A withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    @Override
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    @Override
    public A withGlusterfs(GlusterfsVolumeSource glusterfs) {
        this._visitables.remove(this.glusterfs);
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs() {
        return new GlusterfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs() != null ? this.getGlusterfs() : new GlusterfsVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item) {
        return this.withNewGlusterfsLike(this.getGlusterfs() != null ? this.getGlusterfs() : item);
    }

    @Override
    public A withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    @Override
    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    @Override
    public A withHostPath(HostPathVolumeSource hostPath) {
        this._visitables.remove(this.hostPath);
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath() {
        return new HostPathNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPath() {
        return this.withNewHostPathLike(this.getHostPath() != null ? this.getHostPath() : new HostPathVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item) {
        return this.withNewHostPathLike(this.getHostPath() != null ? this.getHostPath() : item);
    }

    @Override
    public A withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    @Override
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    @Override
    public A withIscsi(ISCSIVolumeSource iscsi) {
        this._visitables.remove(this.iscsi);
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi() {
        return new IscsiNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsi() {
        return this.withNewIscsiLike(this.getIscsi() != null ? this.getIscsi() : new ISCSIVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item) {
        return this.withNewIscsiLike(this.getIscsi() != null ? this.getIscsi() : item);
    }

    @Override
    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    @Override
    public A withNfs(NFSVolumeSource nfs) {
        this._visitables.remove(this.nfs);
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs() {
        return new NfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfs() {
        return this.withNewNfsLike(this.getNfs() != null ? this.getNfs() : new NFSVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item) {
        return this.withNewNfsLike(this.getNfs() != null ? this.getNfs() : item);
    }

    @Override
    public A withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    @Override
    public String getPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy;
    }

    @Override
    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        return (A)this;
    }

    @Override
    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    @Override
    public A withRbd(RBDVolumeSource rbd) {
        this._visitables.remove(this.rbd);
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd() {
        return new RbdNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbd() {
        return this.withNewRbdLike(this.getRbd() != null ? this.getRbd() : new RBDVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item) {
        return this.withNewRbdLike(this.getRbd() != null ? this.getRbd() : item);
    }

    @Override
    public VsphereVirtualDiskVolumeSource getVsphereVolume() {
        return this.vsphereVolume != null ? (VsphereVirtualDiskVolumeSource)this.vsphereVolume.build() : null;
    }

    @Override
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume) {
        this._visitables.remove(this.vsphereVolume);
        if (vsphereVolume != null) {
            this.vsphereVolume = new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume);
            this._visitables.add(this.vsphereVolume);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume() {
        return new VsphereVolumeNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
        return new VsphereVolumeNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume() {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume());
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolume() {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume() != null ? this.getVsphereVolume() : new VsphereVirtualDiskVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume() != null ? this.getVsphereVolume() : item);
    }

    @Override
    public A withNewVsphereVolume(String fsType, String volumePath) {
        return this.withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, volumePath));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.azureFile != null ? !this.azureFile.equals(that.azureFile) : that.azureFile != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.cinder != null ? !this.cinder.equals(that.cinder) : that.cinder != null) {
            return false;
        }
        if (this.claimRef != null ? !this.claimRef.equals(that.claimRef) : that.claimRef != null) {
            return false;
        }
        if (this.fc != null ? !this.fc.equals(that.fc) : that.fc != null) {
            return false;
        }
        if (this.flexVolume != null ? !this.flexVolume.equals(that.flexVolume) : that.flexVolume != null) {
            return false;
        }
        if (this.flocker != null ? !this.flocker.equals(that.flocker) : that.flocker != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeReclaimPolicy != null ? !this.persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) : that.persistentVolumeReclaimPolicy != null) {
            return false;
        }
        if (this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null) {
            return false;
        }
        return !(this.vsphereVolume != null ? !this.vsphereVolume.equals(that.vsphereVolume) : that.vsphereVolume != null);
    }

    public class VsphereVolumeNestedImpl<N>
    extends VsphereVirtualDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.VsphereVolumeNested<N>>
    implements PersistentVolumeSpecFluent.VsphereVolumeNested<N>,
    Nested<N> {
        private final VsphereVirtualDiskVolumeSourceBuilder builder;

        VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item) {
            this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
        }

        VsphereVolumeNestedImpl() {
            this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withVsphereVolume(this.builder.build());
        }

        @Override
        public N endVsphereVolume() {
            return this.and();
        }
    }

    public class RbdNestedImpl<N>
    extends RBDVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>>
    implements PersistentVolumeSpecFluent.RbdNested<N>,
    Nested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNestedImpl(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        RbdNestedImpl() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withRbd(this.builder.build());
        }

        @Override
        public N endRbd() {
            return this.and();
        }
    }

    public class NfsNestedImpl<N>
    extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>>
    implements PersistentVolumeSpecFluent.NfsNested<N>,
    Nested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNestedImpl(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        NfsNestedImpl() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withNfs(this.builder.build());
        }

        @Override
        public N endNfs() {
            return this.and();
        }
    }

    public class IscsiNestedImpl<N>
    extends ISCSIVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>>
    implements PersistentVolumeSpecFluent.IscsiNested<N>,
    Nested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNestedImpl(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        IscsiNestedImpl() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withIscsi(this.builder.build());
        }

        @Override
        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNestedImpl<N>
    extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>>
    implements PersistentVolumeSpecFluent.HostPathNested<N>,
    Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNestedImpl(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        HostPathNestedImpl() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withHostPath(this.builder.build());
        }

        @Override
        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNestedImpl<N>
    extends GlusterfsVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>>
    implements PersistentVolumeSpecFluent.GlusterfsNested<N>,
    Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNestedImpl(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        GlusterfsNestedImpl() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGlusterfs(this.builder.build());
        }

        @Override
        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GcePersistentDiskNestedImpl<N>
    extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>
    implements PersistentVolumeSpecFluent.GcePersistentDiskNested<N>,
    Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        GcePersistentDiskNestedImpl() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(this.builder.build());
        }

        @Override
        public N endGcePersistentDisk() {
            return this.and();
        }
    }

    public class FlockerNestedImpl<N>
    extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>>
    implements PersistentVolumeSpecFluent.FlockerNested<N>,
    Nested<N> {
        private final FlockerVolumeSourceBuilder builder;

        FlockerNestedImpl(FlockerVolumeSource item) {
            this.builder = new FlockerVolumeSourceBuilder(this, item);
        }

        FlockerNestedImpl() {
            this.builder = new FlockerVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlocker(this.builder.build());
        }

        @Override
        public N endFlocker() {
            return this.and();
        }
    }

    public class FlexVolumeNestedImpl<N>
    extends FlexVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlexVolumeNested<N>>
    implements PersistentVolumeSpecFluent.FlexVolumeNested<N>,
    Nested<N> {
        private final FlexVolumeSourceBuilder builder;

        FlexVolumeNestedImpl(FlexVolumeSource item) {
            this.builder = new FlexVolumeSourceBuilder(this, item);
        }

        FlexVolumeNestedImpl() {
            this.builder = new FlexVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlexVolume(this.builder.build());
        }

        @Override
        public N endFlexVolume() {
            return this.and();
        }
    }

    public class FcNestedImpl<N>
    extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>>
    implements PersistentVolumeSpecFluent.FcNested<N>,
    Nested<N> {
        private final FCVolumeSourceBuilder builder;

        FcNestedImpl(FCVolumeSource item) {
            this.builder = new FCVolumeSourceBuilder(this, item);
        }

        FcNestedImpl() {
            this.builder = new FCVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFc(this.builder.build());
        }

        @Override
        public N endFc() {
            return this.and();
        }
    }

    public class ClaimRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>>
    implements PersistentVolumeSpecFluent.ClaimRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ClaimRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ClaimRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withClaimRef(this.builder.build());
        }

        @Override
        public N endClaimRef() {
            return this.and();
        }
    }

    public class CinderNestedImpl<N>
    extends CinderVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>>
    implements PersistentVolumeSpecFluent.CinderNested<N>,
    Nested<N> {
        private final CinderVolumeSourceBuilder builder;

        CinderNestedImpl(CinderVolumeSource item) {
            this.builder = new CinderVolumeSourceBuilder(this, item);
        }

        CinderNestedImpl() {
            this.builder = new CinderVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCinder(this.builder.build());
        }

        @Override
        public N endCinder() {
            return this.and();
        }
    }

    public class CephfsNestedImpl<N>
    extends CephFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>>
    implements PersistentVolumeSpecFluent.CephfsNested<N>,
    Nested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNestedImpl(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        CephfsNestedImpl() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCephfs(this.builder.build());
        }

        @Override
        public N endCephfs() {
            return this.and();
        }
    }

    public class AzureFileNestedImpl<N>
    extends AzureFileVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureFileNested<N>>
    implements PersistentVolumeSpecFluent.AzureFileNested<N>,
    Nested<N> {
        private final AzureFileVolumeSourceBuilder builder;

        AzureFileNestedImpl(AzureFileVolumeSource item) {
            this.builder = new AzureFileVolumeSourceBuilder(this, item);
        }

        AzureFileNestedImpl() {
            this.builder = new AzureFileVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAzureFile(this.builder.build());
        }

        @Override
        public N endAzureFile() {
            return this.and();
        }
    }

    public class AwsElasticBlockStoreNestedImpl<N>
    extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>
    implements PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>,
    Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        AwsElasticBlockStoreNestedImpl() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(this.builder.build());
        }

        @Override
        public N endAwsElasticBlockStore() {
            return this.and();
        }
    }
}

