/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.database.mysql.MySqlCluster;
import org.apache.brooklyn.entity.database.mysql.MySqlClusterImpl;
import org.apache.brooklyn.entity.database.mysql.MySqlClusterUtils;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.entity.database.mysql.MySqlRowParser;
import org.apache.brooklyn.entity.database.mysql.ReplicationSnapshot;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSlaveTaskBody
implements Runnable {
    private static final String SNAPSHOT_DUMP_OPTIONS = "--skip-lock-tables --single-transaction --flush-logs --hex-blob";
    private static final Logger log = LoggerFactory.getLogger(InitSlaveTaskBody.class);
    private final MySqlCluster cluster;
    private final MySqlNode slave;
    private Semaphore lock;

    public InitSlaveTaskBody(MySqlCluster cluster, MySqlNode slave, Semaphore lock) {
        this.cluster = cluster;
        this.slave = slave;
        this.lock = lock;
    }

    @Override
    public void run() {
        this.bootstrapSlaveAsync(this.getValidReplicationInfo(), this.slave);
        ((Map)this.cluster.getAttribute(MySqlClusterImpl.SLAVE_ID_ADDRESS_MAPPING)).put(this.slave.getId(), this.slave.getAttribute(MySqlNode.SUBNET_ADDRESS));
    }

    private MySqlNode getMaster() {
        return (MySqlNode)Iterables.find((Iterable)this.cluster.getMembers(), MySqlClusterUtils.IS_MASTER);
    }

    private void bootstrapSlaveAsync(final Future<ReplicationSnapshot> replicationInfoFuture, final MySqlNode slave) {
        DynamicTasks.queue((String)"bootstrap slave replication", (Runnable)new Runnable(){

            @Override
            public void run() {
                ReplicationSnapshot replicationSnapshot;
                try {
                    replicationSnapshot = (ReplicationSnapshot)replicationInfoFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
                MySqlNode master = InitSlaveTaskBody.this.getMaster();
                String masterAddress = MySqlClusterUtils.validateSqlParam((String)master.getAttribute(MySqlNode.SUBNET_ADDRESS));
                Integer masterPort = (Integer)master.getAttribute((AttributeSensor)MySqlNode.MYSQL_PORT);
                String slaveAddress = MySqlClusterUtils.validateSqlParam((String)slave.getAttribute(MySqlNode.SUBNET_ADDRESS));
                String username = MySqlClusterUtils.validateSqlParam((String)InitSlaveTaskBody.this.cluster.getConfig(MySqlCluster.SLAVE_USERNAME));
                String password = MySqlClusterUtils.validateSqlParam((String)InitSlaveTaskBody.this.cluster.getAttribute((AttributeSensor)MySqlCluster.SLAVE_PASSWORD));
                if (replicationSnapshot.getEntityId() != null) {
                    Entity sourceEntity = (Entity)Iterables.find((Iterable)InitSlaveTaskBody.this.cluster.getMembers(), (Predicate)EntityPredicates.idEqualTo((String)replicationSnapshot.getEntityId()));
                    String dumpId = FilenameUtils.removeExtension((String)replicationSnapshot.getSnapshotPath());
                    InitSlaveTaskBody.this.copyDumpAsync(sourceEntity, slave, replicationSnapshot.getSnapshotPath(), dumpId);
                    DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)slave, MySqlNode.IMPORT_DUMP, (Map)ImmutableMap.of((Object)"path", (Object)replicationSnapshot.getSnapshotPath())));
                    DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)slave, MySqlNode.CHANGE_PASSWORD, (Map)ImmutableMap.of((Object)"password", (Object)slave.getAttribute((AttributeSensor)MySqlNode.PASSWORD))));
                    MySqlClusterUtils.executeSqlOnNodeAsync(slave, "FLUSH PRIVILEGES;");
                }
                MySqlClusterUtils.executeSqlOnNodeAsync(master, String.format("CREATE USER '%s'@'%s' IDENTIFIED BY '%s';\nGRANT REPLICATION SLAVE ON *.* TO '%s'@'%s';\n", username, slaveAddress, password, username, slaveAddress));
                String slaveCmd = String.format("CHANGE MASTER TO MASTER_HOST='%s', MASTER_PORT=%d, MASTER_USER='%s', MASTER_PASSWORD='%s', MASTER_LOG_FILE='%s', MASTER_LOG_POS=%d;\nSTART SLAVE;\n", masterAddress, masterPort, username, password, replicationSnapshot.getBinLogName(), replicationSnapshot.getBinLogPosition());
                MySqlClusterUtils.executeSqlOnNodeAsync(slave, slaveCmd);
            }
        });
    }

    private void copyDumpAsync(Entity source, Entity dest, String sourceDumpPath, String dumpId) {
        SshMachineLocation sourceMachine = EffectorTasks.getSshMachine((Entity)source);
        final SshMachineLocation destMachine = EffectorTasks.getSshMachine((Entity)dest);
        String sourceRunDir = (String)source.getAttribute((AttributeSensor)MySqlNode.RUN_DIR);
        String privateKeyFile = dumpId + ".id_rsa";
        final Task tempKeyTask = ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd $RUN_DIR", "PRIVATE_KEY=" + privateKeyFile, "ssh-keygen -t rsa -N '' -f $PRIVATE_KEY -C " + dumpId + " > /dev/null", "cat $PRIVATE_KEY.pub"}).environmentVariable("RUN_DIR", sourceRunDir)).machine(sourceMachine)).summary("generate private key for slave access")).requiringZeroAndReturningStdout())).asTask();
        DynamicTasks.queue((String)"add key to authorized_keys", (Runnable)new Runnable(){

            @Override
            public void run() {
                String publicKey = (String)tempKeyTask.getUnchecked();
                DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{String.format("cat >> ~/.ssh/authorized_keys <<EOF\n%s\nEOF", publicKey)}).machine(destMachine)).summary("Add key to authorized_keys")).requiringExitCodeZero());
            }
        });
        final ProcessTaskWrapper copyTask = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd $RUN_DIR", String.format("scp -o 'BatchMode yes' -o 'StrictHostKeyChecking no' -i '%s' '%s' '%s@%s:%s/%s.sql'", privateKeyFile, sourceDumpPath, destMachine.getUser(), dest.getAttribute(MySqlNode.SUBNET_ADDRESS), dest.getAttribute((AttributeSensor)MySqlNode.RUN_DIR), dumpId)}).environmentVariable("RUN_DIR", sourceRunDir)).machine(sourceMachine)).summary("copy database dump to slave")).newTask();
        TaskTags.markInessential((TaskAdaptable)copyTask);
        DynamicTasks.queue((TaskAdaptable)copyTask);
        DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd $RUN_DIR", "rm " + privateKeyFile}).environmentVariable("RUN_DIR", sourceRunDir)).machine(sourceMachine)).summary("remove private key"));
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{String.format("sed -i'' -e '/%s/d' ~/.ssh/authorized_keys", dumpId)}).machine(destMachine)).summary("remove private key from authorized_keys"))).asTask();
        DynamicTasks.queue((String)"check for successful copy", (Runnable)new Runnable(){

            @Override
            public void run() {
                copyTask.asTask().getUnchecked();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<ReplicationSnapshot> getValidReplicationInfo() {
        try {
            try {
                this.lock.acquire();
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            ReplicationSnapshot replicationSnapshot = this.getReplicationInfoMasterConfig();
            if (replicationSnapshot == null) {
                replicationSnapshot = this.getAttributeBlocking((Entity)this.cluster, MySqlCluster.REPLICATION_LAST_SLAVE_SNAPSHOT);
            }
            if (!this.isReplicationInfoValid(replicationSnapshot)) {
                MySqlNode snapshotNode = this.getSnapshotNode();
                String dumpName = this.getDumpUniqueId() + ".sql";
                if (MySqlClusterUtils.IS_MASTER.apply((Object)snapshotNode)) {
                    Future<ReplicationSnapshot> future = this.createMasterReplicationSnapshot(snapshotNode, dumpName);
                    return future;
                }
                Future<ReplicationSnapshot> future = this.createSlaveReplicationSnapshot(snapshotNode, dumpName);
                return future;
            }
            Future future = ConcurrentUtils.constantFuture((Object)replicationSnapshot);
            return future;
        }
        finally {
            this.lock.release();
        }
    }

    @Deprecated
    private ReplicationSnapshot getReplicationInfoMasterConfig() {
        MySqlNode master = this.getMaster();
        AttributeSensor MASTER_LOG_FILE = Sensors.newStringSensor((String)"mysql.master.log_file", (String)"The binary log file master is writing to");
        AttributeSensor MASTER_LOG_POSITION = Sensors.newIntegerSensor((String)"mysql.master.log_position", (String)"The position in the log file to start replication");
        String logFile = (String)master.sensors().get(MASTER_LOG_FILE);
        Integer logPos = (Integer)master.sensors().get(MASTER_LOG_POSITION);
        if (logFile != null && logPos != null) {
            ReplicationSnapshot replicationSnapshot = new ReplicationSnapshot(null, null, logFile, logPos);
            this.cluster.sensors().set(MySqlCluster.REPLICATION_LAST_SLAVE_SNAPSHOT, (Object)replicationSnapshot);
            master.sensors().set(MASTER_LOG_FILE, null);
            master.sensors().set(MASTER_LOG_POSITION, null);
            return replicationSnapshot;
        }
        return null;
    }

    private Future<ReplicationSnapshot> createMasterReplicationSnapshot(final MySqlNode master, final String dumpName) {
        log.info("MySql cluster " + this.cluster + ": generating new replication snapshot on master node " + master + " with name " + dumpName);
        String dumpOptions = "--skip-lock-tables --single-transaction --flush-logs --hex-blob --master-data=2" + this.getDumpDatabases(master);
        ImmutableMap params = ImmutableMap.of((Object)MySqlNode.ExportDumpEffector.PATH.getName(), (Object)dumpName, (Object)MySqlNode.ExportDumpEffector.ADDITIONAL_OPTIONS.getName(), (Object)dumpOptions);
        DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)master, MySqlNode.EXPORT_DUMP, (Map)params));
        return DynamicTasks.queue((String)"get master log info from dump", (Callable)new Callable<ReplicationSnapshot>(){

            @Override
            public ReplicationSnapshot call() throws Exception {
                String masterInfo;
                Pattern masterInfoPattern = Pattern.compile("CHANGE MASTER TO.*MASTER_LOG_FILE\\s*=\\s*'([^']+)'.*MASTER_LOG_POS\\s*=\\s*(\\d+)");
                Matcher masterInfoMatcher = masterInfoPattern.matcher(masterInfo = (String)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)InitSlaveTaskBody.this.execSshTask(master, "grep -m1 'CHANGE MASTER TO' " + dumpName, "Extract master replication status from dump").requiringZeroAndReturningStdout())).asTask().getUnchecked());
                if (!masterInfoMatcher.find() || masterInfoMatcher.groupCount() != 2) {
                    throw new IllegalStateException("Master dump doesn't contain replication info: " + masterInfo);
                }
                String masterLogFile = masterInfoMatcher.group(1);
                int masterLogPosition = Integer.parseInt(masterInfoMatcher.group(2));
                ReplicationSnapshot replicationSnapshot = new ReplicationSnapshot(master.getId(), dumpName, masterLogFile, masterLogPosition);
                InitSlaveTaskBody.this.cluster.sensors().set(MySqlCluster.REPLICATION_LAST_SLAVE_SNAPSHOT, (Object)replicationSnapshot);
                return replicationSnapshot;
            }
        });
    }

    private String getDumpDatabases(MySqlNode node) {
        Collection dumpDbs = (Collection)node.config().get(MySqlCluster.SLAVE_REPLICATE_DUMP_DB);
        if (dumpDbs != null && !dumpDbs.isEmpty()) {
            return " --databases " + Joiner.on((char)' ').join(Iterables.transform((Iterable)dumpDbs, (Function)StringEscapes.BashStringEscapes.wrapBash()));
        }
        return " --all-databases";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<ReplicationSnapshot> createSlaveReplicationSnapshot(final MySqlNode slave, final String dumpName) {
        MySqlClusterUtils.executeSqlOnNodeAsync(slave, "STOP SLAVE SQL_THREAD;");
        try {
            log.info("MySql cluster " + this.cluster + ": generating new replication snapshot on slave node " + slave + " with name " + dumpName);
            String dumpOptions = SNAPSHOT_DUMP_OPTIONS + this.getDumpDatabases(slave);
            ImmutableMap params = ImmutableMap.of((Object)MySqlNode.ExportDumpEffector.PATH.getName(), (Object)dumpName, (Object)MySqlNode.ExportDumpEffector.ADDITIONAL_OPTIONS.getName(), (Object)dumpOptions);
            DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)slave, MySqlNode.EXPORT_DUMP, (Map)params));
            Task task = DynamicTasks.queue((String)"get master log info from slave", (Callable)new Callable<ReplicationSnapshot>(){

                @Override
                public ReplicationSnapshot call() throws Exception {
                    String slaveStatusRow = slave.executeScript("SHOW SLAVE STATUS \\G");
                    Map<String, String> slaveStatus = MySqlRowParser.parseSingle(slaveStatusRow);
                    String masterLogFile = slaveStatus.get("Relay_Master_Log_File");
                    int masterLogPosition = Integer.parseInt(slaveStatus.get("Exec_Master_Log_Pos"));
                    ReplicationSnapshot replicationSnapshot = new ReplicationSnapshot(slave.getId(), dumpName, masterLogFile, masterLogPosition);
                    InitSlaveTaskBody.this.cluster.sensors().set(MySqlCluster.REPLICATION_LAST_SLAVE_SNAPSHOT, (Object)replicationSnapshot);
                    return replicationSnapshot;
                }
            });
            return task;
        }
        finally {
            MySqlClusterUtils.executeSqlOnNodeAsync(slave, "START SLAVE SQL_THREAD;");
        }
    }

    private MySqlNode getSnapshotNode() {
        String snapshotNodeId = (String)this.cluster.getConfig(MySqlCluster.REPLICATION_PREFERRED_SOURCE);
        if (snapshotNodeId != null) {
            Optional preferredNode = Iterables.tryFind((Iterable)this.cluster.getMembers(), (Predicate)EntityPredicates.idEqualTo((String)snapshotNodeId));
            if (preferredNode.isPresent()) {
                return (MySqlNode)preferredNode.get();
            }
            log.warn("MySql cluster " + this + " configured with preferred snapshot node " + snapshotNodeId + " but it's not a member. Defaulting to a random slave.");
        }
        return this.getRandomSlave();
    }

    private MySqlNode getRandomSlave() {
        ImmutableList<MySqlNode> slaves = this.getHealhtySlaves();
        if (slaves.size() > 0) {
            return (MySqlNode)slaves.get(new Random().nextInt(slaves.size()));
        }
        return this.getMaster();
    }

    private ImmutableList<MySqlNode> getHealhtySlaves() {
        return FluentIterable.from((Iterable)this.cluster.getMembers()).filter(Predicates.not(MySqlClusterUtils.IS_MASTER)).filter(EntityPredicates.attributeEqualTo((AttributeSensor)MySqlNode.SERVICE_UP, (Object)Boolean.TRUE)).filter(MySqlNode.class).toList();
    }

    private boolean isReplicationInfoValid(ReplicationSnapshot replicationSnapshot) {
        MySqlNode master = this.getMaster();
        String dataDir = Strings.nullToEmpty((String)((String)master.getConfig(MySqlNode.DATA_DIR)));
        if (!this.checkFileExistsOnEntity(master, Os.mergePathsUnix((String[])new String[]{dataDir, replicationSnapshot.getBinLogName()}))) {
            return false;
        }
        if (replicationSnapshot.getEntityId() != null) {
            Optional snapshotSlave = Iterables.tryFind((Iterable)this.cluster.getChildren(), (Predicate)EntityPredicates.idEqualTo((String)replicationSnapshot.getEntityId()));
            if (!snapshotSlave.isPresent()) {
                log.info("MySql cluster " + this.cluster + " missing node " + replicationSnapshot.getEntityId() + " with last snapshot " + replicationSnapshot.getSnapshotPath() + ". Will generate new snapshot.");
                return false;
            }
            if (!this.checkFileExistsOnEntity((Entity)snapshotSlave.get(), replicationSnapshot.getSnapshotPath())) {
                log.info("MySql cluster " + this.cluster + ", node " + snapshotSlave.get() + " missing replication snapshot " + replicationSnapshot.getSnapshotPath() + ". Will generate new snapshot.");
                return false;
            }
        }
        return true;
    }

    private boolean checkFileExistsOnEntity(Entity entity, String path) {
        String summary;
        String cmd = BashCommands.chain((String[])new String[]{BashCommands.requireTest((String)String.format("-f \"%s\"", path), (String)("File " + path + " doesn't exist."))});
        return (Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)this.execSshTask(entity, cmd, summary = "Check if file " + path + " exists").allowingNonZeroExitCode())).asTask().getUnchecked() == 0;
    }

    private ProcessTaskFactory<Integer> execSshTask(Entity entity, String cmd, String summary) {
        SshMachineLocation machine = EffectorTasks.getSshMachine((Entity)entity);
        return SshTasks.newSshExecTaskFactory((SshMachineLocation)machine, (String[])new String[]{"cd $RUN_DIR\n" + cmd}).allowingNonZeroExitCode().environmentVariable("RUN_DIR", (String)entity.getAttribute((AttributeSensor)SoftwareProcess.RUN_DIR)).summary(summary);
    }

    private <T> T getAttributeBlocking(Entity masterNode, AttributeSensor<T> att) {
        return (T)((Task)DynamicTasks.queue((TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)masterNode, att))).getUnchecked();
    }

    private String getDumpUniqueId() {
        return "replication-dump-" + Identifiers.makeRandomId((int)8) + "-" + new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss").format(new Date());
    }
}

