/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.glob;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Glob {
    static Logger logger = LoggerFactory.getLogger(Glob.class);
    public static final Glob ALL = new Glob("*");
    private final String glob;
    private final Pattern pattern;

    public Glob(String globString) {
        this(globString, 0);
    }

    public Glob(String globString, int flags) {
        this(globString, Pattern.compile(Glob.convertGlobToRegEx(globString), flags));
    }

    Glob(String globString, Pattern pattern) {
        this.glob = globString;
        this.pattern = pattern;
    }

    public Matcher matcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    public String toString() {
        return this.glob;
    }

    private static String convertGlobToRegEx(String line) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen << 2);
        int curlyLevel = 0;
        State state = State.SIMPLE;
        int previousChar = 0;
        for (int i = 0; i < strLen; ++i) {
            int currentChar = line.charAt(i);
            switch (currentChar) {
                case 42: {
                    if (!(state != State.SIMPLE && state != State.CURLIES || Glob.isEnd((char)previousChar))) {
                        sb.append('.');
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 63: {
                    if (!(state != State.SIMPLE && state != State.CURLIES || Glob.isStart((char)previousChar) || Glob.isEnd((char)previousChar))) {
                        sb.append('.');
                        break;
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 43: {
                    if (!(state != State.SIMPLE && state != State.CURLIES || Glob.isEnd((char)previousChar))) {
                        sb.append('\\');
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 92: {
                    sb.append((char)currentChar);
                    if (i + 1 >= strLen) break;
                    char nextChar = line.charAt(++i);
                    if (state == State.SIMPLE && nextChar == 'Q') {
                        state = State.QUOTED;
                    } else if (state == State.QUOTED && nextChar == 'E') {
                        state = State.SIMPLE;
                    }
                    sb.append(nextChar);
                    break;
                }
                case 91: {
                    if (state == State.SIMPLE) {
                        state = State.BRACKETS;
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 93: {
                    if (state == State.BRACKETS) {
                        state = State.SIMPLE;
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 123: {
                    if (!(state != State.SIMPLE && state != State.CURLIES || Glob.isEnd((char)previousChar))) {
                        state = State.CURLIES;
                        sb.append("(?:");
                        ++curlyLevel;
                        break;
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 125: {
                    if (state == State.CURLIES && curlyLevel > 0) {
                        sb.append(')');
                        currentChar = 41;
                        if (--curlyLevel != 0) break;
                        state = State.SIMPLE;
                        break;
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 44: {
                    if (state == State.CURLIES) {
                        sb.append('|');
                        break;
                    }
                    sb.append((char)currentChar);
                    break;
                }
                case 36: 
                case 37: 
                case 46: 
                case 64: 
                case 94: {
                    if (state == State.SIMPLE || state == State.CURLIES) {
                        sb.append('\\');
                    }
                }
                default: {
                    sb.append((char)currentChar);
                }
            }
            previousChar = currentChar;
        }
        return sb.toString();
    }

    private static boolean isStart(char c) {
        return c == '(';
    }

    private static boolean isEnd(char c) {
        return c == ')' || c == ']';
    }

    public void select(Collection<?> objects) {
        Iterator<?> i = objects.iterator();
        while (i.hasNext()) {
            String s = i.next().toString();
            if (this.matches(s)) continue;
            i.remove();
        }
    }

    public void select(List<?> objects) {
        this.select((Collection<?>)objects);
    }

    public static Pattern toPattern(String s) {
        return Glob.toPattern(s, 0);
    }

    public static Pattern toPattern(String s, int flags) {
        try {
            return Pattern.compile(Glob.convertGlobToRegEx(s), flags);
        }
        catch (Exception e) {
            logger.info("failing regex in glob", (Throwable)e);
            return null;
        }
    }

    public List<File> getFiles(File root, boolean recursive, boolean usePath) {
        ArrayList<File> result = new ArrayList<File>();
        this.getFiles(root, result, recursive, usePath);
        return result;
    }

    public void getFiles(File root, List<File> result, boolean recursive, boolean usePath) {
        if (root == null || !root.isDirectory()) {
            return;
        }
        for (File sub : root.listFiles()) {
            if (sub.isFile()) {
                String s;
                String string = s = usePath ? sub.getAbsolutePath() : sub.getName();
                if (!this.matcher(s).matches()) continue;
                result.add(sub);
                continue;
            }
            if (!recursive || !sub.isDirectory()) continue;
            this.getFiles(sub, result, recursive, usePath);
        }
    }

    public static boolean in(Glob[] globs, String key) {
        for (Glob g : globs) {
            if (!g.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Collection<? extends Glob> globs, String key) {
        for (Glob glob : globs) {
            if (!glob.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.glob == null ? 0 : this.glob.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Glob other = (Glob)obj;
        return !(this.glob == null ? other.glob != null : !this.glob.equals(other.glob));
    }

    public boolean matches(String s) {
        return this.matcher(s).matches();
    }

    static enum State {
        SIMPLE,
        CURLIES,
        BRACKETS,
        QUOTED;

    }
}

