/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.test.framework.BaseTest;
import org.apache.brooklyn.test.framework.TestSshCommandImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@ImplementedBy(value=TestSshCommandImpl.class)
public interface TestSshCommand
extends BaseTest {
    public static final String TMP_DEFAULT = "/tmp";
    public static final ConfigKey<Duration> BACKOFF_TO_PERIOD = ConfigKeys.newConfigKeyWithDefault(BaseTest.BACKOFF_TO_PERIOD, (Object)Duration.seconds((Number)5));
    @SetFromFlag(nullable=false)
    public static final ConfigKey<String> COMMAND = ConfigKeys.newConfigKey(String.class, (String)"command", (String)"Command to invoke");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = SoftwareProcess.DOWNLOAD_URL;
    @SetFromFlag(value="env")
    public static final ConfigKey<Map<String, Object>> SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    @SetFromFlag(value="scriptDir")
    public static final ConfigKey<String> SCRIPT_DIR = ConfigKeys.newConfigKey((String)"script.dir", (String)"directory where downloaded scripts should be put", (Object)"/tmp");
    @SetFromFlag(value="runDir")
    public static final ConfigKey<String> RUN_DIR = ConfigKeys.newConfigKey(String.class, (String)"run.dir", (String)"directory where downloaded scripts should be run from");
    public static final Map<String, Object> DEFAULT_ASSERTION = ImmutableMap.of((Object)"equals", (Object)0);
    @SetFromFlag(value="assertStatus")
    public static final ConfigKey<Object> ASSERT_STATUS = ConfigKeys.newConfigKey(Object.class, (String)"assert.status", (String)"Assertions on command exit code", (Object)ImmutableList.of());
    @SetFromFlag(value="assertOut")
    public static final ConfigKey<Object> ASSERT_OUT = ConfigKeys.newConfigKey(Object.class, (String)"assert.out", (String)"Assertions on command standard output", (Object)ImmutableList.of());
    @SetFromFlag(value="assertErr")
    public static final ConfigKey<Object> ASSERT_ERR = ConfigKeys.newConfigKey(Object.class, (String)"assert.err", (String)"Assertions on command standard error", (Object)ImmutableList.of());
    public static final ConfigKey<Integer> MAX_ATTEMPTS = ConfigKeys.newIntegerConfigKey((String)"maxAttempts", (String)"Maximum number of attempts");
}

