/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.module.api;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class UiModuleFilter
implements Filter {
    private static final String CACHE_CONTROL = "Cache-Control";
    private String cacheHeaderValue;
    private boolean addCacheHeader = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter(CACHE_CONTROL) != null) {
            this.addCacheHeader = true;
            this.cacheHeaderValue = filterConfig.getInitParameter(CACHE_CONTROL);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.addCacheHeader && servletResponse instanceof HttpServletResponse) {
            ((HttpServletResponse)servletResponse).setHeader(CACHE_CONTROL, this.cacheHeaderValue);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

