/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Visitor;

public class ParameterAnnotationEntry
implements Node {
    private final AnnotationEntry[] annotationTable;

    ParameterAnnotationEntry(DataInput input, ConstantPool constant_pool) throws IOException {
        int annotation_table_length = input.readUnsignedShort();
        this.annotationTable = new AnnotationEntry[annotation_table_length];
        for (int i = 0; i < annotation_table_length; ++i) {
            this.annotationTable[i] = AnnotationEntry.read(input, constant_pool, false);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitParameterAnnotationEntry(this);
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotationTable;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.annotationTable.length);
        for (AnnotationEntry entry : this.annotationTable) {
            entry.dump(dos);
        }
    }

    public static ParameterAnnotationEntry[] createParameterAnnotationEntries(Attribute[] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof ParameterAnnotations)) continue;
            ParameterAnnotations runtimeAnnotations = (ParameterAnnotations)attribute;
            Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getParameterAnnotationEntries());
        }
        return accumulatedAnnotations.toArray(new ParameterAnnotationEntry[accumulatedAnnotations.size()]);
    }
}

