/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.aries.cdi.container.internal.annotated;

import java.lang.reflect.Method;

import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

public class AnnotatedMethodImpl<X> extends AnnotatedCallableImpl<X> implements AnnotatedMethod<X> {

	public AnnotatedMethodImpl(final AnnotatedType<X> declaringType, final Method method) {
		super(method.getGenericReturnType(), method, declaringType, method);
	}

	@Override
	public Method getJavaMember() {
		return (Method)super.getJavaMember();
	}

}
